/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hash-to-random-exchange")
public class HashToRandomExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(HashToRandomExchange.class);
    private final LogicalExpression expr;
    private List<CoordinationProtos.DrillbitEndpoint> senderLocations;
    private List<CoordinationProtos.DrillbitEndpoint> receiverLocations;

    @JsonCreator
    public HashToRandomExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr) {
        super(child);
        this.expr = expr;
    }

    @Override
    public int getMaxSendWidth() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) {
        this.senderLocations = senderLocations;
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) {
        this.receiverLocations = receiverLocations;
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new HashPartitionSender(this.receiverMajorFragmentId, child, this.expr, this.receiverLocations);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, this.senderLocations);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashToRandomExchange(child, this.expr);
    }
}

