/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.AbstractSender;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hash-partition-sender")
public class HashPartitionSender
extends AbstractSender {
    static final Logger logger = LoggerFactory.getLogger(HashPartitionSender.class);
    private final List<CoordinationProtos.DrillbitEndpoint> endpoints;
    private final LogicalExpression expr;

    @JsonCreator
    public HashPartitionSender(@JsonProperty(value="receiver-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="destinations") List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        super(oppositeMajorFragmentId, child);
        this.expr = expr;
        this.endpoints = endpoints;
    }

    public List<CoordinationProtos.DrillbitEndpoint> getDestinations() {
        return this.endpoints;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashPartitionSender(this.oppositeMajorFragmentId, child, this.expr, this.endpoints);
    }

    public LogicalExpression getExpr() {
        return this.expr;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitHashPartitionSender(this, value);
    }

    @Override
    public int getOperatorType() {
        return 6;
    }
}

