/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hash-aggregate")
public class HashAggregate
extends AbstractSingle {
    static final Logger logger = LoggerFactory.getLogger(HashAggregate.class);
    private final NamedExpression[] groupByExprs;
    private final NamedExpression[] aggrExprs;
    private final float cardinality;

    @JsonCreator
    public HashAggregate(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="keys") NamedExpression[] groupByExprs, @JsonProperty(value="exprs") NamedExpression[] aggrExprs, @JsonProperty(value="cardinality") float cardinality) {
        super(child);
        this.groupByExprs = groupByExprs;
        this.aggrExprs = aggrExprs;
        this.cardinality = cardinality;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitHashAggregate(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashAggregate(child, this.groupByExprs, this.aggrExprs, this.cardinality);
    }

    @Override
    public int getOperatorType() {
        return 3;
    }
}

