/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.config.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="external-sort")
public class ExternalSort
extends Sort {
    static final Logger logger = LoggerFactory.getLogger(ExternalSort.class);
    private long initialAllocation = 20000000L;

    @JsonCreator
    public ExternalSort(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="reverse") boolean reverse) {
        super(child, orderings, reverse);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSort(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        ExternalSort newSort = new ExternalSort(child, this.orderings, this.reverse);
        newSort.setMaxAllocation(this.getMaxAllocation());
        return newSort;
    }

    @Override
    public int getOperatorType() {
        return 17;
    }

    public void setMaxAllocation(long maxAllocation) {
        this.maxAllocation = Math.max(this.initialAllocation, maxAllocation);
    }

    @Override
    public long getInitialAllocation() {
        return this.initialAllocation;
    }
}

