/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.BroadcastSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.proto.CoordinationProtos;

@JsonTypeName(value="broadcast-exchange")
public class BroadcastExchange
extends AbstractExchange {
    private List<CoordinationProtos.DrillbitEndpoint> senderLocations;
    private List<CoordinationProtos.DrillbitEndpoint> receiverLocations;

    @JsonCreator
    public BroadcastExchange(@JsonProperty(value="child") PhysicalOperator child) {
        super(child);
    }

    @Override
    protected void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) throws PhysicalOperatorSetupException {
        this.senderLocations = senderLocations;
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        this.receiverLocations = receiverLocations;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new BroadcastExchange(child);
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) throws PhysicalOperatorSetupException {
        return new BroadcastSender(this.receiverMajorFragmentId, child, this.receiverLocations);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, this.senderLocations);
    }

    @Override
    public int getMaxSendWidth() {
        return Integer.MAX_VALUE;
    }
}

