/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import java.util.List;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExchange
extends AbstractSingle
implements Exchange {
    static final Logger logger = LoggerFactory.getLogger(AbstractExchange.class);
    protected int senderMajorFragmentId;
    protected int receiverMajorFragmentId;

    public AbstractExchange(PhysicalOperator child) {
        super(child);
    }

    protected abstract void setupSenders(List<CoordinationProtos.DrillbitEndpoint> var1) throws PhysicalOperatorSetupException;

    protected abstract void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> var1) throws PhysicalOperatorSetupException;

    @Override
    public final void setupSenders(int majorFragmentId, List<CoordinationProtos.DrillbitEndpoint> senderLocations) throws PhysicalOperatorSetupException {
        this.senderMajorFragmentId = majorFragmentId;
        this.setupSenders(senderLocations);
    }

    @Override
    public final void setupReceivers(int majorFragmentId, List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        this.receiverMajorFragmentId = majorFragmentId;
        this.setupReceivers(receiverLocations);
    }

    @Override
    public final <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitExchange(this, value);
    }

    @Override
    public int getOperatorType() {
        throw new UnsupportedOperationException();
    }
}

