/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.google.common.base.Preconditions;
import org.apache.drill.common.graph.GraphVisitor;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.record.BatchSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBase
implements PhysicalOperator {
    static final Logger logger = LoggerFactory.getLogger(AbstractBase.class);
    protected long initialAllocation = 1000000L;
    protected long maxAllocation = 10000000000L;
    private int id;
    private double cost;

    @Override
    public void accept(GraphVisitor<PhysicalOperator> visitor) {
        visitor.enter(this);
        if (this.iterator() == null) {
            throw new IllegalArgumentException("Null iterator for pop." + this);
        }
        for (PhysicalOperator o : this) {
            Preconditions.checkNotNull(o, String.format("Null in iterator for pop %s.", this));
            o.accept(visitor);
        }
        visitor.leave(this);
    }

    @Override
    public final void setOperatorId(int id) {
        this.id = id;
    }

    @Override
    public int getOperatorId() {
        return this.id;
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public long getInitialAllocation() {
        return this.initialAllocation;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Override
    public long getMaxAllocation() {
        return this.maxAllocation;
    }
}

