/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import com.carrotsearch.hppc.IntDoubleOpenHashMap;
import com.carrotsearch.hppc.IntLongOpenHashMap;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.OpProfileDef;
import org.apache.drill.exec.proto.UserBitShared;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorStats {
    static final Logger logger = LoggerFactory.getLogger(OperatorStats.class);
    protected final int operatorId;
    protected final int operatorType;
    private final BufferAllocator allocator;
    private IntLongOpenHashMap longMetrics = new IntLongOpenHashMap();
    private IntDoubleOpenHashMap doubleMetrics = new IntDoubleOpenHashMap();
    public long[] recordsReceivedByInput;
    public long[] batchesReceivedByInput;
    private long[] schemaCountByInput;
    private boolean inProcessing = false;
    private boolean inSetup = false;
    private boolean inWait = false;
    protected long processingNanos;
    protected long setupNanos;
    protected long waitNanos;
    private long processingMark;
    private long setupMark;
    private long waitMark;

    public OperatorStats(OpProfileDef def, BufferAllocator allocator) {
        this(def.getOperatorId(), def.getOperatorType(), def.getIncomingCount(), allocator);
    }

    private OperatorStats(int operatorId, int operatorType, int inputCount, BufferAllocator allocator) {
        this.allocator = allocator;
        this.operatorId = operatorId;
        this.operatorType = operatorType;
        this.recordsReceivedByInput = new long[inputCount];
        this.batchesReceivedByInput = new long[inputCount];
        this.schemaCountByInput = new long[inputCount];
    }

    private String assertionError(String msg) {
        return String.format("Failure while %s for operator id %d. Currently have states of processing:%s, setup:%s, waiting:%s.", msg, this.operatorId, this.inProcessing, this.inSetup, this.inWait);
    }

    public void startSetup() {
        assert (!this.inSetup) : this.assertionError("starting setup");
        this.stopProcessing();
        this.inSetup = true;
        this.setupMark = System.nanoTime();
    }

    public void stopSetup() {
        assert (this.inSetup) : this.assertionError("stopping setup");
        this.startProcessing();
        this.setupNanos += System.nanoTime() - this.setupMark;
        this.inSetup = false;
    }

    public void startProcessing() {
        assert (!this.inProcessing) : this.assertionError("starting processing");
        this.processingMark = System.nanoTime();
        this.inProcessing = true;
    }

    public void stopProcessing() {
        assert (this.inProcessing) : this.assertionError("stopping processing");
        this.processingNanos += System.nanoTime() - this.processingMark;
        this.inProcessing = false;
    }

    public void startWait() {
        assert (!this.inWait) : this.assertionError("starting waiting");
        this.stopProcessing();
        this.inWait = true;
        this.waitMark = System.nanoTime();
    }

    public void stopWait() {
        assert (this.inWait) : this.assertionError("stopping waiting");
        this.startProcessing();
        this.waitNanos += System.nanoTime() - this.waitMark;
        this.inWait = false;
    }

    public void batchReceived(int inputIndex, long records, boolean newSchema) {
        int n = inputIndex;
        this.recordsReceivedByInput[n] = this.recordsReceivedByInput[n] + records;
        int n2 = inputIndex;
        this.batchesReceivedByInput[n2] = this.batchesReceivedByInput[n2] + 1L;
        if (newSchema) {
            int n3 = inputIndex;
            this.schemaCountByInput[n3] = this.schemaCountByInput[n3] + 1L;
        }
    }

    public UserBitShared.OperatorProfile getProfile() {
        UserBitShared.OperatorProfile.Builder b = UserBitShared.OperatorProfile.newBuilder().setOperatorType(this.operatorType).setOperatorId(this.operatorId).setSetupNanos(this.setupNanos).setProcessNanos(this.processingNanos).setWaitNanos(this.waitNanos);
        if (this.allocator != null) {
            b.setLocalMemoryAllocated(this.allocator.getAllocatedMemory());
        }
        this.addAllMetrics(b);
        return b.build();
    }

    public void addAllMetrics(UserBitShared.OperatorProfile.Builder builder) {
        this.addStreamProfile(builder);
        this.addLongMetrics(builder);
        this.addDoubleMetrics(builder);
    }

    public void addStreamProfile(UserBitShared.OperatorProfile.Builder builder) {
        for (int i = 0; i < this.recordsReceivedByInput.length; ++i) {
            builder.addInputProfile(UserBitShared.StreamProfile.newBuilder().setBatches(this.batchesReceivedByInput[i]).setRecords(this.recordsReceivedByInput[i]).setSchemas(this.schemaCountByInput[i]));
        }
    }

    public void addLongMetrics(UserBitShared.OperatorProfile.Builder builder) {
        for (int i = 0; i < this.longMetrics.allocated.length; ++i) {
            if (!this.longMetrics.allocated[i]) continue;
            builder.addMetric(UserBitShared.MetricValue.newBuilder().setMetricId(this.longMetrics.keys[i]).setLongValue(this.longMetrics.values[i]));
        }
    }

    public void addDoubleMetrics(UserBitShared.OperatorProfile.Builder builder) {
        for (int i = 0; i < this.doubleMetrics.allocated.length; ++i) {
            if (!this.doubleMetrics.allocated[i]) continue;
            builder.addMetric(UserBitShared.MetricValue.newBuilder().setMetricId(this.doubleMetrics.keys[i]).setDoubleValue(this.doubleMetrics.values[i]));
        }
    }

    public void addLongStat(MetricDef metric, long value) {
        this.longMetrics.putOrAdd(metric.metricId(), value, value);
    }

    public void setLongStat(MetricDef metric, long value) {
        this.longMetrics.put(metric.metricId(), value);
    }
}

