/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import org.apache.drill.common.config.DrillConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillMetrics {
    static final Logger logger = LoggerFactory.getLogger(DrillMetrics.class);
    static final DrillConfig config = DrillConfig.create();

    private DrillMetrics() {
    }

    public static MetricRegistry getInstance() {
        return RegistryHolder.REGISTRY;
    }

    private static class RegistryHolder {
        public static final MetricRegistry REGISTRY = new MetricRegistry();

        private static void registerSysStats() {
            REGISTRY.registerAll(new GarbageCollectorMetricSet());
            REGISTRY.registerAll(new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            REGISTRY.registerAll(new MemoryUsageGaugeSet());
            REGISTRY.registerAll(new ThreadStatesGaugeSet());
        }

        static {
            RegistryHolder.registerSysStats();
        }
    }
}

