/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DrillBuf;
import io.netty.buffer.PooledByteBufAllocatorL;
import io.netty.buffer.UnsafeDirectLittleEndian;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.memory.Accountor;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelAllocator
implements BufferAllocator {
    static final Logger logger = LoggerFactory.getLogger(TopLevelAllocator.class);
    private static final boolean ENABLE_ACCOUNTING = AssertionUtil.isAssertionsEnabled();
    private final Map<ChildAllocator, StackTraceElement[]> childrenMap;
    private final PooledByteBufAllocatorL innerAllocator = PooledByteBufAllocatorL.DEFAULT;
    private final Accountor acct;
    private final boolean errorOnLeak;
    private final DrillBuf empty;

    @Deprecated
    public TopLevelAllocator() {
        this(DrillConfig.getMaxDirectMemory());
    }

    @Deprecated
    public TopLevelAllocator(long maximumAllocation) {
        this(maximumAllocation, true);
    }

    private TopLevelAllocator(long maximumAllocation, boolean errorOnLeak) {
        this.errorOnLeak = errorOnLeak;
        this.acct = new Accountor(errorOnLeak, null, null, maximumAllocation, 0L);
        this.empty = DrillBuf.getEmpty(this, this.acct);
        this.childrenMap = ENABLE_ACCOUNTING ? new IdentityHashMap() : null;
    }

    public TopLevelAllocator(DrillConfig config) {
        this(Math.min(DrillConfig.getMaxDirectMemory(), config.getLong("drill.exec.memory.top.max")), config.getBoolean("drill.exec.debug.error_on_leak"));
    }

    @Override
    public boolean takeOwnership(DrillBuf buf) {
        return buf.transferAccounting(this.acct);
    }

    public DrillBuf buffer(int min, int max) {
        if (min == 0) {
            return this.empty;
        }
        if (!this.acct.reserve(min)) {
            return null;
        }
        UnsafeDirectLittleEndian buffer = this.innerAllocator.directBuffer(min, max);
        DrillBuf wrapped = new DrillBuf(this, this.acct, buffer);
        this.acct.reserved(min, wrapped);
        return wrapped;
    }

    @Override
    public DrillBuf buffer(int size) {
        return this.buffer(size, size);
    }

    @Override
    public long getAllocatedMemory() {
        return this.acct.getAllocation();
    }

    @Override
    public ByteBufAllocator getUnderlyingAllocator() {
        return this.innerAllocator;
    }

    @Override
    public BufferAllocator getChildAllocator(ExecProtos.FragmentHandle handle, long initialReservation, long maximumReservation) throws OutOfMemoryException {
        if (!this.acct.reserve(initialReservation)) {
            throw new OutOfMemoryException(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.acct.getCapacity() - this.acct.getAllocation()));
        }
        logger.debug("New child allocator with initial reservation {}", (Object)initialReservation);
        ChildAllocator allocator = new ChildAllocator(handle, this.acct, maximumReservation, initialReservation, this.childrenMap);
        if (ENABLE_ACCOUNTING) {
            this.childrenMap.put(allocator, Thread.currentThread().getStackTrace());
        }
        return allocator;
    }

    @Override
    public void close() {
        if (ENABLE_ACCOUNTING) {
            for (Map.Entry<ChildAllocator, StackTraceElement[]> child : this.childrenMap.entrySet()) {
                if (child.getKey().isClosed()) continue;
                StringBuilder sb = new StringBuilder();
                StackTraceElement[] elements = child.getValue();
                for (int i = 0; i < elements.length; ++i) {
                    sb.append("\t\t");
                    sb.append(elements[i]);
                    sb.append("\n");
                }
                throw new IllegalStateException("Failure while trying to close allocator: Child level allocators not closed. Stack trace: \n" + sb);
            }
        }
        this.acct.close();
    }

    @Override
    public DrillBuf getEmpty() {
        return this.empty;
    }

    private class ChildAllocator
    implements BufferAllocator {
        private final DrillBuf empty;
        private Accountor childAcct;
        private Map<ChildAllocator, StackTraceElement[]> children = new HashMap<ChildAllocator, StackTraceElement[]>();
        private boolean closed = false;
        private ExecProtos.FragmentHandle handle;
        private Map<ChildAllocator, StackTraceElement[]> thisMap;

        public ChildAllocator(ExecProtos.FragmentHandle handle, Accountor parentAccountor, long max, long pre, Map<ChildAllocator, StackTraceElement[]> map) throws OutOfMemoryException {
            assert (max >= pre);
            this.childAcct = new Accountor(TopLevelAllocator.this.errorOnLeak, handle, parentAccountor, max, pre);
            this.handle = handle;
            this.thisMap = map;
            this.empty = DrillBuf.getEmpty(this, this.childAcct);
        }

        @Override
        public boolean takeOwnership(DrillBuf buf) {
            return buf.transferAccounting(this.childAcct);
        }

        public DrillBuf buffer(int size, int max) {
            if (size == 0) {
                return this.empty;
            }
            if (!this.childAcct.reserve(size)) {
                logger.warn("Unable to allocate buffer of size {} due to memory limit. Current allocation: {}", size, this.getAllocatedMemory(), new Exception());
                return null;
            }
            UnsafeDirectLittleEndian buffer = TopLevelAllocator.this.innerAllocator.directBuffer(size, max);
            DrillBuf wrapped = new DrillBuf(this, this.childAcct, buffer);
            this.childAcct.reserved(buffer.capacity(), wrapped);
            return wrapped;
        }

        @Override
        public DrillBuf buffer(int size) {
            return this.buffer(size, size);
        }

        @Override
        public ByteBufAllocator getUnderlyingAllocator() {
            return TopLevelAllocator.this.innerAllocator;
        }

        @Override
        public BufferAllocator getChildAllocator(ExecProtos.FragmentHandle handle, long initialReservation, long maximumReservation) throws OutOfMemoryException {
            if (!this.childAcct.reserve(initialReservation)) {
                throw new OutOfMemoryException(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.childAcct.getAvailable()));
            }
            logger.debug("New child allocator with initial reservation {}", (Object)initialReservation);
            ChildAllocator newChildAllocator = new ChildAllocator(handle, this.childAcct, maximumReservation, initialReservation, null);
            this.children.put(newChildAllocator, Thread.currentThread().getStackTrace());
            return newChildAllocator;
        }

        @Override
        public void close() {
            if (ENABLE_ACCOUNTING) {
                if (this.thisMap != null) {
                    this.thisMap.remove(this);
                }
                for (ChildAllocator child : this.children.keySet()) {
                    if (child.isClosed()) continue;
                    StringBuilder sb = new StringBuilder();
                    StackTraceElement[] elements = this.children.get(child);
                    for (int i = 3; i < elements.length; ++i) {
                        sb.append("\t\t");
                        sb.append(elements[i]);
                        sb.append("\n");
                    }
                    IllegalStateException e = new IllegalStateException(String.format("Failure while trying to close child allocator: Child level allocators not closed. Fragment %d:%d. Stack trace: \n %s", this.handle.getMajorFragmentId(), this.handle.getMinorFragmentId(), sb.toString()));
                    if (TopLevelAllocator.this.errorOnLeak) {
                        throw e;
                    }
                    logger.warn("Memory leak.", e);
                }
            }
            this.childAcct.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getAllocatedMemory() {
            return this.childAcct.getAllocation();
        }

        @Override
        public DrillBuf getEmpty() {
            return this.empty;
        }
    }
}

