/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicRemainder {
    static final Logger logger = LoggerFactory.getLogger(AtomicRemainder.class);
    private final AtomicRemainder parent;
    private final AtomicLong availableShared;
    private final AtomicLong availablePrivate;
    private final long initTotal;
    private final long initShared;
    private final long initPrivate;
    private boolean closed = false;
    private final boolean errorOnLeak;

    public AtomicRemainder(boolean errorOnLeak, AtomicRemainder parent, long max, long pre) {
        this.errorOnLeak = errorOnLeak;
        this.parent = parent;
        this.availableShared = new AtomicLong(max - pre);
        this.availablePrivate = new AtomicLong(pre);
        this.initTotal = max;
        this.initShared = max - pre;
        this.initPrivate = pre;
    }

    public long getRemainder() {
        return this.availableShared.get() + this.availablePrivate.get();
    }

    public long getUsed() {
        return this.initTotal - this.getRemainder();
    }

    public boolean forceGet(long size) {
        if (this.get(size)) {
            return true;
        }
        this.availableShared.addAndGet(size);
        if (this.parent != null) {
            this.parent.forceGet(size);
        }
        return false;
    }

    public boolean get(long size) {
        if (this.availablePrivate.get() < 1L) {
            if (this.parent != null && !this.parent.get(size)) {
                return false;
            }
            long outcome = this.availableShared.addAndGet(-size);
            if (outcome < 0L) {
                long newAvailableShared = this.availableShared.addAndGet(size);
                assert (newAvailableShared <= this.initShared);
                if (this.parent != null) {
                    this.parent.returnAllocation(size);
                }
                return false;
            }
            return true;
        }
        long unaccount = this.availablePrivate.addAndGet(-size);
        if (unaccount >= 0L) {
            return true;
        }
        long additionalSpaceNeeded = -unaccount;
        if (this.parent != null && !this.parent.get(additionalSpaceNeeded)) {
            this.availablePrivate.getAndAdd(size);
            return false;
        }
        long account = this.availableShared.addAndGet(-additionalSpaceNeeded);
        if (account >= 0L) {
            this.availablePrivate.addAndGet(additionalSpaceNeeded);
            return true;
        }
        this.availablePrivate.addAndGet(size);
        this.availableShared.addAndGet(additionalSpaceNeeded);
        this.parent.returnAllocation(additionalSpaceNeeded);
        return false;
    }

    public void returnAllocation(long size) {
        long privateSize = this.availablePrivate.get();
        long privateChange = Math.min(size, this.initPrivate - privateSize);
        long sharedChange = size - privateChange;
        this.availablePrivate.addAndGet(privateChange);
        this.availableShared.addAndGet(sharedChange);
        if (this.parent != null) {
            this.parent.returnAllocation(sharedChange);
        }
        assert (this.getUsed() <= this.initTotal);
    }

    public void close() {
        if (this.closed) {
            logger.warn("Tried to close remainder, but it has already been closed", new Exception());
            return;
        }
        if (this.availablePrivate.get() != this.initPrivate || this.availableShared.get() != this.initShared) {
            IllegalStateException e = new IllegalStateException(String.format("Failure while closing accountor.  Expected private and shared pools to be set to initial values.  However, one or more were not.  Stats are\n\tzone\tinit\tallocated\tdelta \n\tprivate\t%d\t%d\t%d \n\tshared\t%d\t%d\t%d.", this.initPrivate, this.availablePrivate.get(), this.initPrivate - this.availablePrivate.get(), this.initShared, this.availableShared.get(), this.initShared - this.availableShared.get()));
            if (this.errorOnLeak) {
                throw e;
            }
            logger.warn("Memory leaked during query.", e);
        }
        if (this.parent != null) {
            this.parent.returnAllocation(this.initPrivate);
        }
        this.closed = true;
    }
}

