/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.Maps;
import java.io.StringWriter;
import java.util.Map;
import org.apache.drill.exec.expr.fn.ModifiedUnparseVisitor;
import org.codehaus.janino.Java;
import org.codehaus.janino.util.Traverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodGrabbingVisitor {
    static final Logger logger = LoggerFactory.getLogger(MethodGrabbingVisitor.class);
    private Class<?> c;
    private Map<String, String> methods = Maps.newHashMap();
    private ClassFinder classFinder = new ClassFinder();
    private boolean captureMethods = false;

    private MethodGrabbingVisitor(Class<?> c) {
        this.c = c;
    }

    public static Map<String, String> getMethods(Java.CompilationUnit cu, Class<?> c) {
        MethodGrabbingVisitor visitor = new MethodGrabbingVisitor(c);
        cu.getPackageMemberTypeDeclarations()[0].accept(visitor.classFinder.comprehensiveVisitor());
        return visitor.methods;
    }

    public class ClassFinder
    extends Traverser {
        @Override
        public void traverseClassDeclaration(Java.ClassDeclaration cd) {
            boolean prevCapture = MethodGrabbingVisitor.this.captureMethods;
            MethodGrabbingVisitor.this.captureMethods = MethodGrabbingVisitor.this.c.getName().equals(cd.getClassName());
            super.traverseClassDeclaration(cd);
            MethodGrabbingVisitor.this.captureMethods = prevCapture;
        }

        @Override
        public void traverseMethodDeclarator(Java.MethodDeclarator md) {
            if (MethodGrabbingVisitor.this.captureMethods) {
                StringWriter writer = new StringWriter();
                ModifiedUnparseVisitor v = new ModifiedUnparseVisitor(writer);
                md.accept(v);
                v.close();
                writer.flush();
                MethodGrabbingVisitor.this.methods.put(md.name, writer.getBuffer().toString());
            }
        }
    }
}

