/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.PathScanner;
import org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.DrillFunctionRegistry;
import org.apache.drill.exec.expr.fn.PluggableFunctionRegistry;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionImplementationRegistry {
    static final Logger logger = LoggerFactory.getLogger(FunctionImplementationRegistry.class);
    private DrillFunctionRegistry drillFuncRegistry;
    private List<PluggableFunctionRegistry> pluggableFuncRegistries = Lists.newArrayList();

    public FunctionImplementationRegistry(DrillConfig config) {
        this.drillFuncRegistry = new DrillFunctionRegistry(config);
        Set<Class<PluggableFunctionRegistry>> registryClasses = PathScanner.scanForImplementations(PluggableFunctionRegistry.class, config.getStringList("drill.exec.functions"));
        block2: for (Class<PluggableFunctionRegistry> clazz : registryClasses) {
            for (Constructor<?> c : clazz.getConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length == 1 && params[0] == DrillConfig.class) {
                    try {
                        PluggableFunctionRegistry registry = (PluggableFunctionRegistry)c.newInstance(config);
                        this.pluggableFuncRegistries.add(registry);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        logger.warn("Unable to instantiate PluggableFunctionRegistry class '{}'. Skipping it.", (Object)clazz, (Object)e);
                    }
                    continue block2;
                }
                logger.warn("Skipping PluggableFunctionRegistry constructor {} for class {} since it doesn't implement a [constructor(DrillConfig)]", (Object)c, (Object)clazz);
            }
        }
    }

    public void register(DrillOperatorTable operatorTable) {
        this.drillFuncRegistry.register(operatorTable);
        for (PluggableFunctionRegistry registry : this.pluggableFuncRegistries) {
            registry.register(operatorTable);
        }
    }

    public DrillFuncHolder findDrillFunction(FunctionResolver functionResolver, FunctionCall functionCall) {
        return functionResolver.getBestMatch(this.drillFuncRegistry.getMethods(functionCall.getName()), functionCall);
    }

    public DrillFuncHolder findExactMatchingDrillFunction(String name, List<TypeProtos.MajorType> argTypes, TypeProtos.MajorType returnType) {
        for (DrillFuncHolder h : this.drillFuncRegistry.getMethods(name)) {
            if (!h.matches(returnType, argTypes)) continue;
            return h;
        }
        return null;
    }

    public AbstractFuncHolder findNonDrillFunction(FunctionCall functionCall) {
        for (PluggableFunctionRegistry registry : this.pluggableFuncRegistries) {
            AbstractFuncHolder h = registry.getFunction(functionCall);
            if (h == null) continue;
            return h;
        }
        return null;
    }

    public boolean isFunctionComplexOutput(String name) {
        List<DrillFuncHolder> methods = this.drillFuncRegistry.getMethods(name);
        for (DrillFuncHolder holder : methods) {
            if (!holder.getReturnValue().isComplexWriter()) continue;
            return true;
        }
        return false;
    }
}

