/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.DrillFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.DrillAggFuncHolder;
import org.apache.drill.exec.expr.fn.DrillBooleanOPHolder;
import org.apache.drill.exec.expr.fn.DrillComplexWriterFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalAddFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalAggFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalCastFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalDivScaleFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalMaxScaleFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalModScaleFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalSetScaleFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalSumAggFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalSumScaleFuncHolder;
import org.apache.drill.exec.expr.fn.DrillDecimalZeroScaleFuncHolder;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import org.apache.drill.exec.expr.fn.ImportGrabber;
import org.apache.drill.exec.expr.fn.MethodGrabbingVisitor;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.mortbay.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionConverter {
    static final Logger logger = LoggerFactory.getLogger(FunctionConverter.class);
    private Map<String, Java.CompilationUnit> functionUnits = Maps.newHashMap();

    /*
     * Loose catch block
     */
    private Java.CompilationUnit get(Class<?> c) throws IOException {
        String path = c.getName();
        path = path.replaceFirst("\\$.*", "");
        path = path.replace(".", "/");
        path = "/" + path + ".java";
        Java.CompilationUnit cu = this.functionUnits.get(path);
        if (cu != null) {
            return cu;
        }
        URL u = Resources.getResource(c, path);
        InputSupplier<InputStream> supplier = Resources.newInputStreamSupplier(u);
        Throwable throwable = null;
        try (InputStream is = supplier.getInput();){
            if (is == null) {
                throw new IOException(String.format("Failure trying to located source code for Class %s, tried to read on classpath location %s", c.getName(), path));
            }
            String body = IO.toString((InputStream)is);
            body = body.replaceAll("@\\w+(?:\\([^\\\\]*?\\))?", "");
            try {
                cu = new Parser(new Scanner(null, new StringReader(body))).parseCompilationUnit();
                this.functionUnits.put(path, cu);
                Java.CompilationUnit compilationUnit = cu;
                return compilationUnit;
            }
            catch (CompileException e) {
                Java.CompilationUnit compilationUnit;
                block19: {
                    block20: {
                        logger.warn("Failure while parsing function class:\n{}", (Object)body, (Object)e);
                        compilationUnit = null;
                        if (is == null) break block19;
                        if (throwable == null) break block20;
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        break block19;
                    }
                    is.close();
                }
                return compilationUnit;
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
    }

    public <T extends DrillFunc> DrillFuncHolder getHolder(Class<T> clazz) {
        Java.CompilationUnit cu;
        FunctionTemplate template = clazz.getAnnotation(FunctionTemplate.class);
        if (template == null) {
            return this.failure("Class does not declare FunctionTemplate annotation.", clazz);
        }
        if (template.name().isEmpty() && template.names().length == 0 || !template.name().isEmpty() && template.names().length != 0) {
            return this.failure("Must use only one annotations 'name' or 'names', not both", clazz);
        }
        ArrayList<DrillFuncHolder.ValueReference> params = Lists.newArrayList();
        ArrayList<DrillFuncHolder.WorkspaceReference> workspaceFields = Lists.newArrayList();
        DrillFuncHolder.ValueReference outputField = null;
        for (Field field : clazz.getDeclaredFields()) {
            boolean isInject;
            Param param = field.getAnnotation(Param.class);
            Output output = field.getAnnotation(Output.class);
            Workspace workspace = field.getAnnotation(Workspace.class);
            Inject inject = field.getAnnotation(Inject.class);
            int i = 0;
            if (param != null) {
                ++i;
            }
            if (output != null) {
                ++i;
            }
            if (workspace != null) {
                ++i;
            }
            if (inject != null) {
                ++i;
            }
            if (i == 0) {
                return this.failure("The field must be either a @Param, @Output, @Inject or @Workspace field.", clazz, field);
            }
            if (i > 1) {
                return this.failure("The field must be only one of @Param, @Output, @Inject or @Workspace.  It currently has more than one of these annotations.", clazz, field);
            }
            if (param != null || output != null) {
                if (param != null && FieldReader.class.isAssignableFrom(field.getType())) {
                    params.add(DrillFuncHolder.ValueReference.createFieldReaderRef(field.getName()));
                    continue;
                }
                if (output != null && BaseWriter.ComplexWriter.class.isAssignableFrom(field.getType())) {
                    if (outputField != null) {
                        return this.failure("You've declared more than one @Output field.  You must declare one and only @Output field per Function class.", clazz, field);
                    }
                    outputField = DrillFuncHolder.ValueReference.createComplexWriterRef(field.getName());
                    continue;
                }
                if (!ValueHolder.class.isAssignableFrom(field.getType())) {
                    return this.failure(String.format("The field doesn't holds value of type %s which does not implement the ValueHolder interface.  All fields of type @Param or @Output must extend this interface..", field.getType()), clazz, field);
                }
                TypeProtos.MajorType type = null;
                try {
                    type = this.getStaticFieldValue("TYPE", field.getType(), TypeProtos.MajorType.class);
                }
                catch (Exception e) {
                    return FunctionConverter.failure("Failure while trying to access the ValueHolder's TYPE static variable.  All ValueHolders must contain a static TYPE variable that defines their MajorType.", e, clazz, field.getName());
                }
                DrillFuncHolder.ValueReference p = new DrillFuncHolder.ValueReference(type, field.getName());
                if (param != null) {
                    if (param.constant()) {
                        p.setConstant(true);
                    }
                    params.add(p);
                    continue;
                }
                if (outputField != null) {
                    return this.failure("You've declared more than one @Output field.  You must declare one and only @Output field per Function class.", clazz, field);
                }
                outputField = p;
                continue;
            }
            boolean bl = isInject = inject != null;
            if (isInject && !field.getType().equals(DrillBuf.class)) {
                return this.failure(String.format("Only DrillBuf is allowed to be injected.  You attempted to inject %s.", field.getType()), clazz, field);
            }
            DrillFuncHolder.WorkspaceReference wsReference = new DrillFuncHolder.WorkspaceReference(field.getType(), field.getName(), isInject);
            if (!isInject && template.scope() == FunctionTemplate.FunctionScope.POINT_AGGREGATE && !ValueHolder.class.isAssignableFrom(field.getType())) {
                return this.failure(String.format("Aggregate function '%s' workspace variable '%s' is of type '%s'. Please change it to Holder type.", template.name(), field.getName(), field.getType()), clazz, field);
            }
            if (ValueHolder.class.isAssignableFrom(field.getType())) {
                TypeProtos.MajorType majorType = null;
                try {
                    majorType = this.getStaticFieldValue("TYPE", field.getType(), TypeProtos.MajorType.class);
                }
                catch (Exception e) {
                    return FunctionConverter.failure("Failure while trying to access the ValueHolder's TYPE static variable.  All ValueHolders must contain a static TYPE variable that defines their MajorType.", e, clazz, field.getName());
                }
                wsReference.setMajorType(majorType);
            }
            workspaceFields.add(wsReference);
        }
        if (outputField == null) {
            return this.failure("This function declares zero output fields.  A function must declare one output field.", clazz);
        }
        try {
            cu = this.get(clazz);
            if (cu == null) {
                return null;
            }
        }
        catch (IOException e) {
            return this.failure("Failure while getting class body.", e, clazz);
        }
        try {
            String[] stringArray;
            Map<String, String> methods = MethodGrabbingVisitor.getMethods(cu, clazz);
            List<String> imports = ImportGrabber.getMethods(cu);
            DrillFuncHolder.ValueReference[] ps = params.toArray(new DrillFuncHolder.ValueReference[params.size()]);
            DrillFuncHolder.WorkspaceReference[] works = workspaceFields.toArray(new DrillFuncHolder.WorkspaceReference[workspaceFields.size()]);
            if (template.name().isEmpty()) {
                stringArray = template.names();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = template.name();
            }
            String[] registeredNames = stringArray;
            switch (template.scope()) {
                case POINT_AGGREGATE: {
                    return new DrillAggFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports, template.costCategory());
                }
                case DECIMAL_AGGREGATE: {
                    return new DrillDecimalAggFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_SUM_AGGREGATE: {
                    return new DrillDecimalSumAggFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case SIMPLE: {
                    if (outputField.isComplexWriter) {
                        return new DrillComplexWriterFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                    }
                    return new DrillSimpleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports, template.costCategory());
                }
                case SC_BOOLEAN_OPERATOR: {
                    return new DrillBooleanOPHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_MAX_SCALE: {
                    return new DrillDecimalMaxScaleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_MUL_SCALE: {
                    return new DrillDecimalSumScaleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_ADD_SCALE: {
                    return new DrillDecimalAddFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_CAST: {
                    return new DrillDecimalCastFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_DIV_SCALE: {
                    return new DrillDecimalDivScaleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_MOD_SCALE: {
                    return new DrillDecimalModScaleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_SET_SCALE: {
                    return new DrillDecimalSetScaleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
                case DECIMAL_ZERO_SCALE: {
                    return new DrillDecimalZeroScaleFuncHolder(template.scope(), template.nulls(), template.isBinaryCommutative(), template.isRandom(), registeredNames, ps, outputField, works, methods, imports);
                }
            }
            return this.failure("Unsupported Function Type.", clazz);
        }
        catch (AbstractMethodError | Exception | NoSuchFieldError ex) {
            return this.failure("Failure while creating function holder.", ex, clazz);
        }
    }

    private <T> T getStaticFieldValue(String fieldName, Class<?> valueType, Class<T> c) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field f = valueType.getDeclaredField(fieldName);
        Object val = f.get(null);
        return (T)val;
    }

    private static DrillFuncHolder failure(String message, Throwable t, Class<?> clazz, String fieldName) {
        logger.warn("Failure loading function class {}, field {}. " + message, clazz.getName(), fieldName, t);
        return null;
    }

    private DrillFuncHolder failure(String message, Class<?> clazz, String fieldName) {
        logger.warn("Failure loading function class {}, field {}. " + message, (Object)clazz.getName(), (Object)fieldName);
        return null;
    }

    private DrillFuncHolder failure(String message, Class<?> clazz) {
        logger.warn("Failure loading function class [{}]. Message: {}", (Object)clazz.getName(), (Object)message);
        return null;
    }

    private DrillFuncHolder failure(String message, Throwable t, Class<?> clazz) {
        logger.warn("Failure loading function class [{}]. Message: {}", clazz.getName(), message, t);
        return null;
    }

    private DrillFuncHolder failure(String message, Class<?> clazz, Field field) {
        return this.failure(message, clazz, field.getName());
    }
}

