/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.base.Preconditions;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillSimpleFuncHolder
extends DrillFuncHolder {
    static final Logger logger = LoggerFactory.getLogger(DrillSimpleFuncHolder.class);
    private final String setupBody;
    private final String evalBody;
    private final String resetBody;
    private final String cleanupBody;

    public DrillSimpleFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports) {
        this(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports, FunctionTemplate.FunctionCostCategory.getDefault());
    }

    public DrillSimpleFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports, FunctionTemplate.FunctionCostCategory costCategory) {
        super(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports, costCategory);
        this.setupBody = methods.get("setup");
        this.evalBody = methods.get("eval");
        this.resetBody = methods.get("reset");
        this.cleanupBody = methods.get("cleanup");
        Preconditions.checkNotNull(this.evalBody);
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public ClassGenerator.HoldingContainer renderEnd(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
        for (int i = 0; i < inputVariables.length; ++i) {
            if (!this.parameters[i].isConstant || inputVariables[i].isConstant()) continue;
            throw new DrillRuntimeException(String.format("The argument '%s' of Function '%s' has to be constant!", this.parameters[i].name, this.getRegisteredNames()[0]));
        }
        this.generateBody(g, ClassGenerator.BlockType.SETUP, this.setupBody, inputVariables, workspaceJVars, true);
        ClassGenerator.HoldingContainer c = this.generateEvalBody(g, inputVariables, this.evalBody, workspaceJVars);
        this.generateBody(g, ClassGenerator.BlockType.RESET, this.resetBody, null, workspaceJVars, false);
        this.generateBody(g, ClassGenerator.BlockType.CLEANUP, this.cleanupBody, null, workspaceJVars, false);
        return c;
    }

    protected ClassGenerator.HoldingContainer generateEvalBody(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, String body, JVar[] workspaceJVars) {
        JBlock sub;
        g.getEvalBlock().directStatement(String.format("//---- start of eval portion of %s function. ----//", this.registeredNames[0]));
        JBlock topSub = sub = new JBlock(true, true);
        ClassGenerator.HoldingContainer out = null;
        TypeProtos.MajorType returnValueType = this.returnValue.type;
        if (this.nullHandling == FunctionTemplate.NullHandling.NULL_IF_NULL) {
            Object e = null;
            for (ClassGenerator.HoldingContainer v : inputVariables) {
                if (!v.isOptional()) continue;
                e = e == null ? v.getIsSet() : e.mul((JExpression)v.getIsSet());
            }
            if (e != null) {
                returnValueType = this.returnValue.type.toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build();
                out = g.declare(returnValueType);
                e = e.eq(JExpr.lit((int)0));
                JConditional jc = sub._if((JExpression)e);
                jc._then().assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                sub = jc._else();
            }
        }
        if (out == null) {
            out = g.declare(returnValueType);
        }
        g.getEvalBlock().add((JStatement)topSub);
        JVar internalOutput = sub.decl(8, g.getHolderType(returnValueType), this.returnValue.name, (JExpression)JExpr._new((JType)g.getHolderType(returnValueType)));
        this.addProtectedBlock(g, sub, body, inputVariables, workspaceJVars, false);
        if (sub != topSub) {
            sub.assign((JAssignmentTarget)internalOutput.ref("isSet"), JExpr.lit((int)1));
        }
        sub.assign((JAssignmentTarget)out.getHolder(), (JExpression)internalOutput);
        if (sub != topSub) {
            sub.assign((JAssignmentTarget)internalOutput.ref("isSet"), JExpr.lit((int)1));
        }
        g.getEvalBlock().directStatement(String.format("//---- end of eval portion of %s function. ----//", this.registeredNames[0]));
        return out;
    }
}

