/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.PathScanner;
import org.apache.drill.exec.expr.DrillFunc;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionConverter;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.sql.DrillSqlAggOperator;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.eigenbase.sql.SqlFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillFunctionRegistry {
    static final Logger logger = LoggerFactory.getLogger(DrillFunctionRegistry.class);
    private ArrayListMultimap<String, DrillFuncHolder> methods = ArrayListMultimap.create();

    public DrillFunctionRegistry(DrillConfig config) {
        FunctionConverter converter = new FunctionConverter();
        Set<Class<DrillFunc>> providerClasses = PathScanner.scanForImplementations(DrillFunc.class, config.getStringList("drill.exec.functions"));
        for (Class<DrillFunc> clazz : providerClasses) {
            DrillFuncHolder holder = converter.getHolder(clazz);
            if (holder != null) {
                String[] names;
                for (String name : names = holder.getRegisteredNames()) {
                    this.methods.put((Object)name.toLowerCase(), (Object)holder);
                }
                continue;
            }
            logger.warn("Unable to initialize function for class {}", (Object)clazz.getName());
        }
        if (logger.isTraceEnabled()) {
            StringBuilder allFunctions = new StringBuilder();
            for (DrillFuncHolder method : this.methods.values()) {
                allFunctions.append(method.toString()).append("\n");
            }
            logger.trace("Registered functions: [\n{}]", (Object)allFunctions);
        }
    }

    public List<DrillFuncHolder> getMethods(String name) {
        return this.methods.get((Object)name.toLowerCase());
    }

    public void register(DrillOperatorTable operatorTable) {
        for (Map.Entry function : this.methods.asMap().entrySet()) {
            HashSet<Integer> argCounts = Sets.newHashSet();
            String name = ((String)function.getKey()).toUpperCase();
            for (DrillFuncHolder f : (Collection)function.getValue()) {
                if (!argCounts.add(f.getParamCount())) continue;
                SqlFunction op = f.isAggregating() ? new DrillSqlAggOperator(name, f.getParamCount()) : new DrillSqlOperator(name, f.getParamCount());
                operatorTable.add((String)function.getKey(), op);
            }
        }
    }
}

