/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.bytecode.ScalarReplacementTypes;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillFuncHolder
extends AbstractFuncHolder {
    static final Logger logger = LoggerFactory.getLogger(FunctionImplementationRegistry.class);
    protected final FunctionTemplate.FunctionScope scope;
    protected final FunctionTemplate.NullHandling nullHandling;
    protected final FunctionTemplate.FunctionCostCategory costCategory;
    protected final boolean isBinaryCommutative;
    protected final boolean isRandom;
    protected final String[] registeredNames;
    protected final ImmutableList<String> imports;
    protected final WorkspaceReference[] workspaceVars;
    protected final ValueReference[] parameters;
    protected final ValueReference returnValue;
    protected final ImmutableMap<String, String> methodMap;

    public DrillFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, ValueReference[] parameters, ValueReference returnValue, WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports, FunctionTemplate.FunctionCostCategory costCategory) {
        this.scope = scope;
        this.nullHandling = nullHandling;
        this.workspaceVars = workspaceVars;
        this.isBinaryCommutative = isBinaryCommutative;
        this.isRandom = isRandom;
        this.registeredNames = registeredNames;
        this.methodMap = ImmutableMap.copyOf(methods);
        this.parameters = parameters;
        this.returnValue = returnValue;
        this.imports = ImmutableList.copyOf(imports);
        this.costCategory = costCategory;
    }

    @Override
    public JVar[] renderStart(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables) {
        return this.declareWorkspaceVariables(g);
    }

    @Override
    public void renderMiddle(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
    }

    @Override
    public FunctionHolderExpression getExpr(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new DrillFuncHolderExpr(name, this, args, pos);
    }

    public boolean isAggregating() {
        return false;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    protected JVar[] declareWorkspaceVariables(ClassGenerator<?> g) {
        JVar[] workspaceJVars = new JVar[this.workspaceVars.length];
        for (int i = 0; i < this.workspaceVars.length; ++i) {
            WorkspaceReference ref = this.workspaceVars[i];
            JType jtype = g.getModel()._ref(ref.type);
            if (ScalarReplacementTypes.CLASSES.contains(ref.type)) {
                workspaceJVars[i] = g.declareClassField("work", jtype);
                JBlock b = g.getBlock("__DRILL_INIT__");
                b.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)JExpr._new((JType)jtype));
            } else {
                workspaceJVars[i] = g.declareClassField("work", jtype);
            }
            if (!ref.isInject()) continue;
            g.getBlock(ClassGenerator.BlockType.SETUP).assign((JAssignmentTarget)workspaceJVars[i], (JExpression)g.getMappingSet().getIncoming().invoke("getContext").invoke("getManagedBuffer"));
        }
        return workspaceJVars;
    }

    protected void generateBody(ClassGenerator<?> g, ClassGenerator.BlockType bt, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, boolean decConstantInputOnly) {
        if (!Strings.isNullOrEmpty(body) && !body.trim().isEmpty()) {
            JBlock sub = new JBlock(true, true);
            if (decConstantInputOnly) {
                this.addProtectedBlock(g, sub, body, inputVariables, workspaceJVars, true);
            } else {
                this.addProtectedBlock(g, sub, body, null, workspaceJVars, false);
            }
            g.getBlock(bt).directStatement(String.format("/** start %s for function %s **/ ", bt.name(), this.registeredNames[0]));
            g.getBlock(bt).add((JStatement)sub);
            g.getBlock(bt).directStatement(String.format("/** end %s for function %s **/ ", bt.name(), this.registeredNames[0]));
        }
    }

    protected void addProtectedBlock(ClassGenerator<?> g, JBlock sub, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, boolean decConstInputOnly) {
        int i;
        if (inputVariables != null) {
            for (int i2 = 0; i2 < inputVariables.length; ++i2) {
                if (decConstInputOnly && !inputVariables[i2].isConstant()) continue;
                ValueReference parameter = this.parameters[i2];
                ClassGenerator.HoldingContainer inputVariable = inputVariables[i2];
                if (parameter.isFieldReader && !inputVariable.isReader() && !Types.isComplex(inputVariable.getMajorType())) {
                    JType singularReaderClass = g.getModel()._ref(TypeHelper.getHolderReaderImpl(inputVariable.getMajorType().getMinorType(), inputVariable.getMajorType().getMode()));
                    JType fieldReadClass = g.getModel()._ref(FieldReader.class);
                    sub.decl(fieldReadClass, parameter.name, (JExpression)JExpr._new((JType)singularReaderClass).arg((JExpression)inputVariable.getHolder()));
                    continue;
                }
                sub.decl(inputVariable.getHolder().type(), parameter.name, (JExpression)inputVariable.getHolder());
            }
        }
        JVar[] internalVars = new JVar[workspaceJVars.length];
        for (i = 0; i < workspaceJVars.length; ++i) {
            internalVars[i] = decConstInputOnly ? sub.decl(g.getModel()._ref(this.workspaceVars[i].type), this.workspaceVars[i].name, (JExpression)workspaceJVars[i]) : sub.decl(g.getModel()._ref(this.workspaceVars[i].type), this.workspaceVars[i].name, (JExpression)workspaceJVars[i]);
        }
        Preconditions.checkNotNull(body);
        sub.directStatement(body);
        for (i = 0; i < workspaceJVars.length; ++i) {
            sub.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)internalVars[i]);
        }
    }

    public boolean matches(TypeProtos.MajorType returnType, List<TypeProtos.MajorType> argTypes) {
        if (!this.softCompare(returnType, this.returnValue.type)) {
            return false;
        }
        if (argTypes.size() != this.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.softCompare(this.parameters[i].type, argTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeProtos.MajorType getParmMajorType(int i) {
        return this.parameters[i].type;
    }

    public int getParamCount() {
        return this.parameters.length;
    }

    public boolean isConstant(int i) {
        return this.parameters[i].isConstant;
    }

    public boolean isFieldReader(int i) {
        return this.parameters[i].isFieldReader;
    }

    public TypeProtos.MajorType getReturnType(List<LogicalExpression> args) {
        if (this.nullHandling == FunctionTemplate.NullHandling.NULL_IF_NULL) {
            for (LogicalExpression e : args) {
                if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                return Types.optional(this.returnValue.type.getMinorType());
            }
        }
        return this.returnValue.type;
    }

    public FunctionTemplate.NullHandling getNullHandling() {
        return this.nullHandling;
    }

    private boolean softCompare(TypeProtos.MajorType a, TypeProtos.MajorType b) {
        return Types.softEquals(a, b, this.nullHandling == FunctionTemplate.NullHandling.NULL_IF_NULL);
    }

    public String[] getRegisteredNames() {
        return this.registeredNames;
    }

    public int getCostCategory() {
        return this.costCategory.getValue();
    }

    public String toString() {
        int maxLen = 10;
        return this.getClass().getSimpleName() + " [functionNames=" + Arrays.toString(this.registeredNames) + ", returnType=" + Types.toString(this.returnValue.type) + ", nullHandling=" + (Object)((Object)this.nullHandling) + ", parameters=" + (this.parameters != null ? Arrays.asList(this.parameters).subList(0, Math.min(this.parameters.length, 10)) : null) + "]";
    }

    public boolean checkPrecisionRange() {
        return false;
    }

    public TypeProtos.MajorType getReturnType() {
        return this.returnValue.type;
    }

    public ValueReference getReturnValue() {
        return this.returnValue;
    }

    public static class WorkspaceReference {
        Class<?> type;
        String name;
        TypeProtos.MajorType majorType;
        boolean inject;

        public WorkspaceReference(Class<?> type, String name, boolean inject) {
            Preconditions.checkNotNull(type);
            Preconditions.checkNotNull(name);
            this.type = type;
            this.name = name;
            this.inject = inject;
        }

        void setMajorType(TypeProtos.MajorType majorType) {
            this.majorType = majorType;
        }

        public boolean isInject() {
            return this.inject;
        }
    }

    public static class ValueReference {
        TypeProtos.MajorType type;
        String name;
        boolean isConstant = false;
        boolean isFieldReader = false;
        boolean isComplexWriter = false;

        public ValueReference(TypeProtos.MajorType type, String name) {
            Preconditions.checkNotNull(type);
            Preconditions.checkNotNull(name);
            this.type = type;
            this.name = name;
        }

        public void setConstant(boolean isConstant) {
            this.isConstant = isConstant;
        }

        public String toString() {
            return "ValueReference [type=" + Types.toString(this.type) + ", name=" + this.name + "]";
        }

        public static ValueReference createFieldReaderRef(String name) {
            TypeProtos.MajorType type = Types.required(TypeProtos.MinorType.LATE);
            ValueReference ref = new ValueReference(type, name);
            ref.isFieldReader = true;
            return ref;
        }

        public static ValueReference createComplexWriterRef(String name) {
            TypeProtos.MajorType type = Types.required(TypeProtos.MinorType.LATE);
            ValueReference ref = new ValueReference(type, name);
            ref.isComplexWriter = true;
            return ref;
        }

        public boolean isComplexWriter() {
            return this.isComplexWriter;
        }
    }
}

