/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;

public class DrillDecimalCastFuncHolder
extends DrillSimpleFuncHolder {
    public DrillDecimalCastFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports) {
        super(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports);
    }

    @Override
    public TypeProtos.MajorType getReturnType(List<LogicalExpression> args) {
        TypeProtos.DataMode mode = this.returnValue.type.getMode();
        if (this.nullHandling == FunctionTemplate.NullHandling.NULL_IF_NULL) {
            for (LogicalExpression e : args) {
                if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                mode = TypeProtos.DataMode.OPTIONAL;
                break;
            }
        }
        if (args.size() != 3) {
            StringBuilder err = new StringBuilder();
            for (int i = 0; i < args.size(); ++i) {
                err.append("arg" + i + ": " + args.get(i).getMajorType().getMinorType());
            }
            throw new DrillRuntimeException("Decimal cast function invoked with incorect arguments" + err);
        }
        int scale = (int)((ValueExpressions.LongExpression)args.get(args.size() - 1)).getLong();
        int precision = (int)((ValueExpressions.LongExpression)args.get(args.size() - 2)).getLong();
        return TypeProtos.MajorType.newBuilder().setMinorType(this.returnValue.type.getMinorType()).setScale(scale).setPrecision(precision).setMode(mode).build();
    }
}

