/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JLabel;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.compile.sig.CodeGeneratorArgument;
import org.apache.drill.exec.compile.sig.CodeGeneratorMethod;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.compile.sig.SignatureHolder;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.DirectExpression;
import org.apache.drill.exec.expr.EvaluationVisitor;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassGenerator<T> {
    public static final GeneratorMapping DEFAULT_SCALAR_MAP = GeneratorMapping.GM("doSetup", "doEval", null, null);
    public static final GeneratorMapping DEFAULT_CONSTANT_MAP = GeneratorMapping.GM("doSetup", "doSetup", null, null);
    static final Logger logger = LoggerFactory.getLogger(ClassGenerator.class);
    private final SignatureHolder sig;
    private final EvaluationVisitor evaluationVisitor;
    private final Map<ValueVectorSetup, JVar> vvDeclaration = Maps.newHashMap();
    private final Map<String, ClassGenerator<T>> innerClasses = Maps.newHashMap();
    private final List<TypedFieldId> workspaceTypes = Lists.newArrayList();
    private final Map<DrillFuncHolder.WorkspaceReference, JVar> workspaceVectors = Maps.newHashMap();
    private final CodeGenerator<T> codeGenerator;
    public final JDefinedClass clazz;
    private final LinkedList<JBlock>[] blocks;
    private final JCodeModel model;
    private int index = 0;
    private int labelIndex = 0;
    private MappingSet mappings;

    public static MappingSet getDefaultMapping() {
        return new MappingSet("inIndex", "outIndex", DEFAULT_CONSTANT_MAP, DEFAULT_SCALAR_MAP);
    }

    ClassGenerator(CodeGenerator<T> codeGenerator, MappingSet mappingSet, SignatureHolder signature, EvaluationVisitor eval, JDefinedClass clazz, JCodeModel model) throws JClassAlreadyExistsException {
        this.codeGenerator = codeGenerator;
        this.clazz = clazz;
        this.mappings = mappingSet;
        this.sig = signature;
        this.evaluationVisitor = eval;
        this.model = model;
        this.blocks = new LinkedList[this.sig.size()];
        for (int i = 0; i < this.sig.size(); ++i) {
            this.blocks[i] = Lists.newLinkedList();
        }
        this.rotateBlock();
        for (SignatureHolder child : signature.getChildHolders()) {
            String innerClassName = child.getSignatureClass().getSimpleName();
            JDefinedClass innerClazz = clazz._class(18, innerClassName);
            this.innerClasses.put(innerClassName, new ClassGenerator<T>(codeGenerator, mappingSet, child, eval, innerClazz, model));
        }
    }

    public ClassGenerator<T> getInnerGenerator(String name) {
        ClassGenerator<T> inner = this.innerClasses.get(name);
        Preconditions.checkNotNull(inner);
        return inner;
    }

    public MappingSet getMappingSet() {
        return this.mappings;
    }

    public void setMappingSet(MappingSet mappings) {
        this.mappings = mappings;
    }

    public CodeGenerator<T> getCodeGenerator() {
        return this.codeGenerator;
    }

    private GeneratorMapping getCurrentMapping() {
        return this.mappings.getCurrentMapping();
    }

    public JBlock getBlock(String methodName) {
        JBlock blk = this.blocks[this.sig.get(methodName)].getLast();
        Preconditions.checkNotNull(blk, "Requested method name of %s was not available for signature %s.", methodName, this.sig);
        return blk;
    }

    public JBlock getBlock(BlockType type) {
        return this.getBlock(this.getCurrentMapping().getMethodName(type));
    }

    public JBlock getSetupBlock() {
        return this.getBlock(this.getCurrentMapping().getMethodName(BlockType.SETUP));
    }

    public JBlock getEvalBlock() {
        return this.getBlock(this.getCurrentMapping().getMethodName(BlockType.EVAL));
    }

    public void nestEvalBlock(JBlock block) {
        String methodName = this.getCurrentMapping().getMethodName(BlockType.EVAL);
        this.blocks[this.sig.get(methodName)].addLast(block);
    }

    public void unNestEvalBlock() {
        String methodName = this.getCurrentMapping().getMethodName(BlockType.EVAL);
        this.blocks[this.sig.get(methodName)].removeLast();
    }

    public JLabel getEvalBlockLabel(String prefix) {
        return this.getEvalBlock().label(prefix + this.labelIndex++);
    }

    public JVar declareVectorValueSetupAndMember(String batchName, TypedFieldId fieldId) {
        return this.declareVectorValueSetupAndMember(DirectExpression.direct(batchName), fieldId);
    }

    public JVar declareVectorValueSetupAndMember(DirectExpression batchName, TypedFieldId fieldId) {
        JClass vvClass;
        ValueVectorSetup setup = new ValueVectorSetup(batchName, fieldId);
        Class<? extends ValueVector> valueVectorClass = fieldId.getIntermediateClass();
        JClass retClass = vvClass = this.model.ref(valueVectorClass);
        String vectorAccess = "getValueVector";
        if (fieldId.isHyperReader()) {
            retClass = retClass.array();
            vectorAccess = "getValueVectors";
        }
        JVar vv = this.declareClassField("vv", (JType)retClass);
        JClass t = this.model.ref(SchemaChangeException.class);
        JClass objClass = this.model.ref(Object.class);
        JBlock b = this.getSetupBlock();
        JVar fieldArr = b.decl((JType)this.model.INT.array(), "fieldIds" + this.index++, (JExpression)JExpr.newArray((JType)this.model.INT, (int)fieldId.getFieldIds().length));
        int[] fieldIndices = fieldId.getFieldIds();
        for (int i = 0; i < fieldIndices.length; ++i) {
            b.assign((JAssignmentTarget)fieldArr.component(JExpr.lit((int)i)), JExpr.lit((int)fieldIndices[i]));
        }
        JInvocation invoke = batchName.invoke("getValueAccessorById").arg(vvClass.dotclass()).arg((JExpression)fieldArr);
        JVar obj = b.decl((JType)objClass, this.getNextVar("tmp"), (JExpression)invoke.invoke(vectorAccess));
        b._if(obj.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)t).arg(JExpr.lit((String)String.format("Failure while loading vector %s with id: %s.", vv.name(), fieldId.toString()))));
        b.assign((JAssignmentTarget)vv, (JExpression)JExpr.cast((JType)retClass, (JExpression)obj));
        this.vvDeclaration.put(setup, vv);
        return vv;
    }

    public HoldingContainer addExpr(LogicalExpression ex) {
        return this.addExpr(ex, true);
    }

    public HoldingContainer addExpr(LogicalExpression ex, boolean rotate) {
        if (rotate) {
            this.rotateBlock();
        }
        return this.evaluationVisitor.addExpr(ex, this);
    }

    public void rotateBlock() {
        for (LinkedList<JBlock> b : this.blocks) {
            b.add(new JBlock(true, true));
        }
    }

    void flushCode() {
        int i = 0;
        for (CodeGeneratorMethod codeGeneratorMethod : this.sig) {
            JMethod outer = this.clazz.method(1, this.model._ref(codeGeneratorMethod.getReturnType()), codeGeneratorMethod.getMethodName());
            for (CodeGeneratorArgument codeGeneratorArgument : codeGeneratorMethod) {
                outer.param(codeGeneratorArgument.getType(), codeGeneratorArgument.getName());
            }
            for (Class clazz : codeGeneratorMethod.getThrowsIterable()) {
                outer._throws(this.model.ref(clazz));
            }
            outer._throws(SchemaChangeException.class);
            int methodIndex = 0;
            boolean bl = false;
            boolean isVoidMethod = codeGeneratorMethod.getReturnType() == Void.TYPE;
            for (JBlock b : this.blocks[i++]) {
                int n;
                if (b.isEmpty()) continue;
                if (n > 50) {
                    JMethod inner = this.clazz.method(4, this.model._ref(codeGeneratorMethod.getReturnType()), codeGeneratorMethod.getMethodName() + methodIndex);
                    JInvocation methodCall = JExpr.invoke((JMethod)inner);
                    for (CodeGeneratorArgument codeGeneratorArgument : codeGeneratorMethod) {
                        inner.param(codeGeneratorArgument.getType(), codeGeneratorArgument.getName());
                        methodCall.arg(JExpr.direct((String)codeGeneratorArgument.getName()));
                    }
                    for (Class clazz : codeGeneratorMethod.getThrowsIterable()) {
                        inner._throws(this.model.ref(clazz));
                    }
                    inner._throws(SchemaChangeException.class);
                    if (isVoidMethod) {
                        outer.body().add((JStatement)methodCall);
                    } else {
                        outer.body()._return((JExpression)methodCall);
                    }
                    outer = inner;
                    n = 0;
                    ++methodIndex;
                }
                outer.body().add((JStatement)b);
                n += 1;
            }
        }
        for (ClassGenerator classGenerator : this.innerClasses.values()) {
            classGenerator.flushCode();
        }
    }

    public JCodeModel getModel() {
        return this.model;
    }

    public String getNextVar(String prefix) {
        return prefix + this.index++;
    }

    public JVar declareClassField(String prefix, JType t) {
        return this.clazz.field(0, t, prefix + this.index++);
    }

    public HoldingContainer declare(TypeProtos.MajorType t) {
        return this.declare(t, true);
    }

    public HoldingContainer declare(TypeProtos.MajorType t, boolean includeNewInstance) {
        JType holderType = this.getHolderType(t);
        JVar var = includeNewInstance ? this.getEvalBlock().decl(holderType, "out" + this.index, (JExpression)JExpr._new((JType)holderType)) : this.getEvalBlock().decl(holderType, "out" + this.index);
        JFieldRef outputSet = null;
        if (t.getMode() == TypeProtos.DataMode.OPTIONAL) {
            outputSet = var.ref("isSet");
        }
        ++this.index;
        return new HoldingContainer(t, var, var.ref("value"), outputSet);
    }

    public List<TypedFieldId> getWorkspaceTypes() {
        return this.workspaceTypes;
    }

    public Map<DrillFuncHolder.WorkspaceReference, JVar> getWorkspaceVectors() {
        return this.workspaceVectors;
    }

    public JType getHolderType(TypeProtos.MajorType t) {
        return TypeHelper.getHolderType(this.model, t.getMinorType(), t.getMode());
    }

    public static class HoldingContainer {
        private final JVar holder;
        private final JFieldRef value;
        private final JFieldRef isSet;
        private final TypeProtos.MajorType type;
        private boolean isConstant;
        private final boolean singularRepeated;
        private final boolean isReader;

        public HoldingContainer(TypeProtos.MajorType t, JVar holder, JFieldRef value, JFieldRef isSet) {
            this(t, holder, value, isSet, false, false);
        }

        public HoldingContainer(TypeProtos.MajorType t, JVar holder, JFieldRef value, JFieldRef isSet, boolean singularRepeated, boolean isReader) {
            this.holder = holder;
            this.value = value;
            this.isSet = isSet;
            this.type = t;
            this.isConstant = false;
            this.singularRepeated = singularRepeated;
            this.isReader = isReader;
        }

        public boolean isReader() {
            return this.isReader;
        }

        public boolean isSingularRepeated() {
            return this.singularRepeated;
        }

        public HoldingContainer setConstant(boolean isConstant) {
            this.isConstant = isConstant;
            return this;
        }

        public JFieldRef f(String name) {
            return this.holder.ref(name);
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public JVar getHolder() {
            return this.holder;
        }

        public JFieldRef getValue() {
            return this.value;
        }

        public TypeProtos.MajorType getMajorType() {
            return this.type;
        }

        public JFieldRef getIsSet() {
            Preconditions.checkNotNull(this.isSet, "You cannot access the isSet variable when operating on a non-nullable output value.");
            return this.isSet;
        }

        public boolean isOptional() {
            return this.type.getMode() == TypeProtos.DataMode.OPTIONAL;
        }

        public TypeProtos.MinorType getMinorType() {
            return this.type.getMinorType();
        }
    }

    private static class ValueVectorSetup {
        final DirectExpression batch;
        final TypedFieldId fieldId;

        public ValueVectorSetup(DirectExpression batch, TypedFieldId fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.batch == null ? 0 : this.batch.hashCode());
            result = 31 * result + (this.fieldId == null ? 0 : this.fieldId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueVectorSetup other = (ValueVectorSetup)obj;
            if (this.batch == null ? other.batch != null : !this.batch.equals((Object)other.batch)) {
                return false;
            }
            return !(this.fieldId == null ? other.fieldId != null : !this.fieldId.equals(other.fieldId));
        }
    }

    public static enum BlockType {
        SETUP,
        EVAL,
        RESET,
        CLEANUP;

    }
}

