/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.dotdrill;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.type.SqlTypeName;

@JsonTypeName(value="view")
public class View {
    private final String name;
    private String sql;
    private List<FieldType> fields;
    private List<String> workspaceSchemaPath;

    public View(String name, String sql, RelDataType rowType, List<String> workspaceSchemaPath) {
        this.name = name;
        this.sql = sql;
        this.fields = Lists.newArrayList();
        for (RelDataTypeField f : rowType.getFieldList()) {
            this.fields.add(new FieldType(f.getName(), f.getType()));
        }
        this.workspaceSchemaPath = workspaceSchemaPath == null ? ImmutableList.of() : ImmutableList.copyOf(workspaceSchemaPath);
    }

    public RelDataType getRowType(RelDataTypeFactory factory) {
        if (this.isDynamic()) {
            return new RelDataTypeDrillImpl(new RelDataTypeHolder(), factory);
        }
        ArrayList<RelDataType> types = Lists.newArrayList();
        ArrayList<String> names = Lists.newArrayList();
        for (FieldType field : this.fields) {
            names.add(field.name);
            if (field.precision == null && field.scale == null) {
                types.add(factory.createSqlType(field.type));
                continue;
            }
            if (field.precision != null && field.scale == null) {
                types.add(factory.createSqlType(field.type, field.precision));
                continue;
            }
            types.add(factory.createSqlType(field.type, field.precision, field.scale));
        }
        return factory.createStructType(types, names);
    }

    @JsonIgnore
    public boolean isDynamic() {
        return this.fields.isEmpty();
    }

    @JsonIgnore
    public boolean hasStar() {
        for (FieldType field : this.fields) {
            if (!StarColumnHelper.isNonPrefixedStarColumn(field.name)) continue;
            return true;
        }
        return false;
    }

    public String getSql() {
        return this.sql;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getWorkspaceSchemaPath() {
        return this.workspaceSchemaPath;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FieldType {
        public final String name;
        public final SqlTypeName type;
        public final Integer precision;
        public final Integer scale;

        public FieldType(String name, RelDataType dataType) {
            this.name = name;
            this.type = dataType.getSqlTypeName();
            Integer p = null;
            Integer s = null;
            switch (dataType.getSqlTypeName()) {
                case CHAR: 
                case BINARY: 
                case VARBINARY: 
                case VARCHAR: {
                    p = dataType.getPrecision();
                    break;
                }
                case DECIMAL: {
                    p = dataType.getPrecision();
                    s = dataType.getScale();
                }
            }
            this.precision = p;
            this.scale = s;
        }
    }
}

