/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.dotdrill;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.dotdrill.DotDrillType;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.drill.exec.store.dfs.shim.DrillInputStream;
import org.apache.hadoop.fs.FileStatus;

public class DotDrillFile {
    private FileStatus status;
    private DotDrillType type;
    private DrillFileSystem fs;

    public static DotDrillFile create(DrillFileSystem fs, FileStatus status) {
        for (DotDrillType d : DotDrillType.values()) {
            if (status.isDir() || !d.matches(status)) continue;
            return new DotDrillFile(fs, status, d);
        }
        return null;
    }

    private DotDrillFile(DrillFileSystem fs, FileStatus status, DotDrillType type) {
        this.fs = fs;
        this.status = status;
        this.type = type;
    }

    public DotDrillType getType() {
        return this.type;
    }

    public View getView(DrillConfig config) throws Exception {
        Preconditions.checkArgument(this.type == DotDrillType.VIEW);
        try (DrillInputStream is = this.fs.open(this.status.getPath());){
            View view = config.getMapper().readValue((InputStream)is.getInputStream(), View.class);
            return view;
        }
    }
}

