/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord.zk;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.drill.exec.coord.DistributedSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDistributedSemaphore
implements DistributedSemaphore {
    static final Logger logger = LoggerFactory.getLogger(ZkDistributedSemaphore.class);
    final InterProcessSemaphoreV2 semaphore;

    public ZkDistributedSemaphore(CuratorFramework client, String path, int numberOfLeases) {
        this.semaphore = new InterProcessSemaphoreV2(client, path, numberOfLeases);
    }

    @Override
    public DistributedSemaphore.DistributedLease acquire(long time, TimeUnit unit) throws Exception {
        Lease lease = this.semaphore.acquire(time, unit);
        if (lease != null) {
            return new LeaseHolder(lease);
        }
        return null;
    }

    private class LeaseHolder
    implements DistributedSemaphore.DistributedLease {
        Lease lease;

        public LeaseHolder(Lease lease) {
            this.lease = lease;
        }

        @Override
        public void close() throws Exception {
            this.lease.close();
        }
    }
}

