/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord;

import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillServiceInstanceHelper {
    static final Logger logger = LoggerFactory.getLogger(DrillServiceInstanceHelper.class);
    public static final InstanceSerializer<CoordinationProtos.DrillbitEndpoint> SERIALIZER = new DrillServiceInstanceSerializer();

    private static class DrillServiceInstanceSerializer
    implements InstanceSerializer<CoordinationProtos.DrillbitEndpoint> {
        private DrillServiceInstanceSerializer() {
        }

        @Override
        public byte[] serialize(ServiceInstance<CoordinationProtos.DrillbitEndpoint> i) throws Exception {
            CoordinationProtos.DrillServiceInstance.Builder b = CoordinationProtos.DrillServiceInstance.newBuilder();
            b.setId(i.getId());
            b.setRegistrationTimeUTC(i.getRegistrationTimeUTC());
            b.setEndpoint(i.getPayload());
            return b.build().toByteArray();
        }

        @Override
        public ServiceInstance<CoordinationProtos.DrillbitEndpoint> deserialize(byte[] bytes) throws Exception {
            CoordinationProtos.DrillServiceInstance i = CoordinationProtos.DrillServiceInstance.parseFrom(bytes);
            ServiceInstanceBuilder<CoordinationProtos.DrillbitEndpoint> b = ServiceInstance.builder();
            b.id(i.getId());
            b.name("drill.exec.cluster-id");
            b.registrationTimeUTC(i.getRegistrationTimeUTC());
            b.payload(i.getEndpoint());
            return b.build();
        }
    }
}

