/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.DrillInitMethodVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.RemappingMethodAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeAdapter
extends ClassVisitor {
    static final Logger logger = LoggerFactory.getLogger(MergeAdapter.class);
    private ClassNode classToMerge;
    private ClassTransformer.ClassSet set;
    private Set<String> mergingNames = Sets.newHashSet();
    private boolean hasInit;
    private String name;

    private MergeAdapter(ClassTransformer.ClassSet set, ClassVisitor cv, ClassNode cn) {
        super(262144, cv);
        this.classToMerge = cn;
        this.set = set;
        for (MethodNode o : this.classToMerge.methods) {
            String name = o.name;
            if (name.equals("<init>")) continue;
            if (name.equals("__DRILL_INIT__")) {
                this.hasInit = true;
            }
            this.mergingNames.add(name);
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.startsWith(this.set.precompiled.slash)) {
            name = name.replace(this.set.precompiled.slash, this.set.generated.slash);
            int i = name.lastIndexOf(36);
            outerName = name.substring(0, i);
            super.visitInnerClass(name, outerName, innerName, access);
        } else {
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        System.out.println("Annotation");
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        if (name.contains("$")) {
            super.visit(version, access, name, signature, superName, interfaces);
        } else {
            super.visit(version, access ^ 0x400 | 0x10, name, signature, superName, interfaces);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x400) != 0 || this.mergingNames.contains(name)) {
            return null;
        }
        if (signature != null) {
            signature = signature.replace(this.set.precompiled.slash, this.set.generated.slash);
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!name.equals("<init>")) {
            access |= 0x10;
        } else if (this.hasInit) {
            return new DrillInitMethodVisitor(this.name, mv);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        Iterator<Object> it = this.classToMerge.fields.iterator();
        while (it.hasNext()) {
            it.next().accept(this);
        }
        for (MethodNode mn : this.classToMerge.methods) {
            if (mn.name.equals("<init>")) continue;
            String[] exceptions = new String[mn.exceptions.size()];
            mn.exceptions.toArray(exceptions);
            MethodVisitor mv = this.cv.visitMethod(mn.access | 0x10, mn.name, mn.desc, mn.signature, exceptions);
            mn.instructions.resetLabels();
            ClassTransformer.ClassSet top = this.set;
            while (top.parent != null) {
                top = top.parent;
            }
            mn.accept(new RemappingMethodAdapter(mn.access, mn.desc, mv, new SimpleRemapper(top.precompiled.slash, top.generated.slash)));
        }
        super.visitEnd();
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(access, name, desc, signature, value);
    }

    public static MergedClassResult getMergedClass(ClassTransformer.ClassSet set, byte[] precompiledClass, ClassNode generatedClass) throws IOException {
        ClassWriter writer = new ClassWriter(2);
        RemapClasses re = new RemapClasses(set);
        try {
            RemappingClassAdapter remappingAdapter;
            ClassVisitor visitor = remappingAdapter = new RemappingClassAdapter(writer, re);
            if (generatedClass != null) {
                visitor = new MergeAdapter(set, remappingAdapter, generatedClass);
            }
            ClassReader tReader = new ClassReader(precompiledClass);
            tReader.accept(visitor, 4);
            byte[] outputClass = writer.toByteArray();
            return new MergedClassResult(outputClass, re.getInnerClasses());
        }
        catch (Error | RuntimeException e) {
            logger.error("Failure while merging classes.", e);
            throw e;
        }
    }

    static class RemapClasses
    extends Remapper {
        final Set<String> innerClasses = Sets.newHashSet();
        ClassTransformer.ClassSet top;
        ClassTransformer.ClassSet current;

        public RemapClasses(ClassTransformer.ClassSet set) {
            this.current = set;
            ClassTransformer.ClassSet top = set;
            while (top.parent != null) {
                top = top.parent;
            }
            this.top = top;
        }

        @Override
        public String map(String typeName) {
            if (typeName.startsWith(this.top.precompiled.slash)) {
                if (typeName.startsWith(this.current.precompiled.slash + "$")) {
                    this.innerClasses.add(typeName);
                }
                return typeName.replace(this.top.precompiled.slash, this.top.generated.slash);
            }
            return typeName;
        }

        public Set<String> getInnerClasses() {
            return this.innerClasses;
        }
    }

    public static class MergedClassResult {
        public byte[] bytes;
        public Collection<String> innerClasses;

        public MergedClassResult(byte[] bytes, Collection<String> innerClasses) {
            this.bytes = bytes;
            this.innerClasses = innerClasses;
        }
    }
}

