/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import java.io.StringReader;
import org.apache.drill.exec.compile.AbstractClassCompiler;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaninoClassCompiler
extends AbstractClassCompiler {
    static final Logger logger = LoggerFactory.getLogger(JaninoClassCompiler.class);
    private IClassLoader compilationClassLoader;

    public JaninoClassCompiler(ClassLoader parentClassLoader, boolean debug) {
        super(debug);
        this.compilationClassLoader = new ClassLoaderIClassLoader(parentClassLoader);
    }

    @Override
    protected byte[][] getByteCode(ClassTransformer.ClassNames className, String sourcecode) throws CompileException, IOException, ClassNotFoundException, ClassTransformationException {
        StringReader reader = new StringReader(sourcecode);
        Scanner scanner = new Scanner(null, reader);
        Java.CompilationUnit compilationUnit = new Parser(scanner).parseCompilationUnit();
        ClassFile[] classFiles = new UnitCompiler(compilationUnit, this.compilationClassLoader).compileUnit(this.debug, this.debug, this.debug);
        byte[][] byteCodes = new byte[classFiles.length][];
        for (int i = 0; i < classFiles.length; ++i) {
            byteCodes[i] = classFiles[i].toByteArray();
        }
        return byteCodes;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

