/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.drill.exec.compile.AbstractClassCompiler;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.DrillDiagnosticListener;
import org.apache.drill.exec.compile.DrillJavaFileManager;
import org.apache.drill.exec.compile.DrillJavaFileObject;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JDKClassCompiler
extends AbstractClassCompiler {
    static final Logger logger = LoggerFactory.getLogger(JDKClassCompiler.class);
    private final Collection<String> compilerOptions;
    private final DiagnosticListener<JavaFileObject> listener;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final DrillJavaFileManager fileManager;

    public JDKClassCompiler(ClassLoader classLoader, boolean debug) {
        super(debug);
        if (this.compiler == null) {
            throw new UnsupportedOperationException("JDK Java compiler not available - probably you're running a JRE, not a JDK");
        }
        this.listener = new DrillDiagnosticListener();
        this.fileManager = new DrillJavaFileManager(this.compiler.getStandardFileManager(this.listener, null, Charsets.UTF_8), classLoader);
        this.compilerOptions = Lists.newArrayList(this.debug ? "-g:source,lines,vars" : "-g:none");
    }

    @Override
    protected byte[][] getByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException {
        try {
            DrillJavaFileObject compilationUnit = new DrillJavaFileObject(className.dot, sourceCode);
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, this.listener, this.compilerOptions, null, Collections.singleton(compilationUnit));
            if (!task.call().booleanValue()) {
                throw new CompileException("Compilation failed", null);
            }
            if (!compilationUnit.isCompiled()) {
                throw new ClassNotFoundException(className + ": Class file not created by compilation.");
            }
            return compilationUnit.getByteCode();
        }
        catch (RuntimeException rte) {
            Throwable cause = rte.getCause();
            if (cause != null) {
                if ((cause = cause.getCause()) instanceof CompileException) {
                    throw (CompileException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
            }
            throw rte;
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

