/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.server.options.OptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCompiler {
    static final Logger logger = LoggerFactory.getLogger(CodeCompiler.class);
    private final ClassTransformer transformer;
    private final DistributedCache distributedCache;
    private final LoadingCache<CodeGenerator<?>, GeneratedClassEntry> cache;
    private final DrillConfig config;
    private final OptionManager systemOptionManager;

    public CodeCompiler(DrillConfig config, DistributedCache distributedCache, OptionManager systemOptionManager) {
        this.transformer = new ClassTransformer(distributedCache);
        this.distributedCache = distributedCache;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build(new Loader());
        this.systemOptionManager = systemOptionManager;
        this.config = config;
    }

    public <T> T getImplementationClass(CodeGenerator<?> cg) throws ClassTransformationException, IOException {
        cg.generate();
        try {
            GeneratedClassEntry ce = this.cache.get(cg);
            return ce.clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | ExecutionException e) {
            throw new ClassTransformationException(e);
        }
    }

    private class GeneratedClassEntry {
        private final QueryClassLoader classLoader;
        private final Class<?> clazz;

        public GeneratedClassEntry(QueryClassLoader classLoader, Class<?> c) {
            this.classLoader = classLoader;
            this.clazz = c;
        }
    }

    private class Loader
    extends CacheLoader<CodeGenerator<?>, GeneratedClassEntry> {
        private Loader() {
        }

        @Override
        public GeneratedClassEntry load(CodeGenerator<?> cg) throws Exception {
            QueryClassLoader loader = new QueryClassLoader(CodeCompiler.this.config, CodeCompiler.this.systemOptionManager);
            Class<?> c = CodeCompiler.this.transformer.getImplementationClass(loader, cg.getDefinition(), cg.getGeneratedCode(), cg.getMaterializedClassName());
            return new GeneratedClassEntry(loader, c);
        }
    }
}

