/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.compile.ByteCodeLoader;
import org.apache.drill.exec.compile.MergeAdapter;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.codehaus.commons.compiler.CompileException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTransformer {
    static final Logger logger = LoggerFactory.getLogger(ClassTransformer.class);
    private final ByteCodeLoader byteCodeLoader = new ByteCodeLoader();
    private final DistributedCache cache;

    public ClassTransformer(DistributedCache cache) {
        this.cache = cache;
    }

    private static ClassNode getClassNodeFromByteCode(byte[] bytes) {
        ClassReader iReader = new ClassReader(bytes);
        ClassNode impl = new ClassNode();
        iReader.accept(impl, 8);
        return impl;
    }

    public Class<?> getImplementationClass(QueryClassLoader classLoader, TemplateClassDefinition<?> templateDefinition, String entireClass, String materializedClassName) throws ClassTransformationException {
        try {
            long t1 = System.nanoTime();
            ClassSet set = new ClassSet(null, templateDefinition.getTemplateClassName(), materializedClassName);
            byte[][] implementationClasses = classLoader.getClassByteCode(set.generated, entireClass);
            long totalBytecodeSize = 0L;
            HashMap<String, ClassNode> classesToMerge = Maps.newHashMap();
            for (byte[] clazz : implementationClasses) {
                totalBytecodeSize += (long)clazz.length;
                ClassNode node = ClassTransformer.getClassNodeFromByteCode(clazz);
                classesToMerge.put(node.name, node);
            }
            LinkedList<ClassSet> names = Lists.newLinkedList();
            HashSet<ClassSet> namesCompleted = Sets.newHashSet();
            names.add(set);
            while (!names.isEmpty()) {
                ClassSet nextSet = (ClassSet)names.removeFirst();
                if (namesCompleted.contains(nextSet)) continue;
                ClassNames nextPrecompiled = nextSet.precompiled;
                byte[] precompiledBytes = this.byteCodeLoader.getClassByteCodeFromPath(nextPrecompiled.clazz);
                ClassNames nextGenerated = nextSet.generated;
                ClassNode generatedNode = (ClassNode)classesToMerge.get(nextGenerated.slash);
                MergeAdapter.MergedClassResult result = MergeAdapter.getMergedClass(nextSet, precompiledBytes, generatedNode);
                for (String s : result.innerClasses) {
                    s = s.replace('/', '.');
                    names.add(nextSet.getChild(s));
                }
                classLoader.injectByteCode(nextGenerated.dot, result.bytes);
                namesCompleted.add(nextSet);
            }
            Class<?> c = classLoader.findClass(set.generated.dot);
            if (templateDefinition.getExternalInterface().isAssignableFrom(c)) {
                logger.debug("Done compiling (bytecode size={}, time:{} millis).", (Object)DrillStringUtils.readable(totalBytecodeSize), (Object)((System.nanoTime() - t1) / 1000000L));
                return c;
            }
            throw new ClassTransformationException("The requested class did not implement the expected interface.");
        }
        catch (IOException | ClassNotFoundException | CompileException e) {
            throw new ClassTransformationException(String.format("Failure generating transformation classes for value: \n %s", entireClass), e);
        }
    }

    public static class ClassNames {
        public final String dot;
        public final String slash;
        public final String clazz;

        public ClassNames(String className) {
            this.dot = className;
            this.slash = className.replace('.', '/');
            this.clazz = '/' + this.slash + ".class";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.dot == null ? 0 : this.dot.hashCode());
            result = 31 * result + (this.slash == null ? 0 : this.slash.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassNames other = (ClassNames)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            if (this.dot == null ? other.dot != null : !this.dot.equals(other.dot)) {
                return false;
            }
            return !(this.slash == null ? other.slash != null : !this.slash.equals(other.slash));
        }
    }

    public static class ClassSet {
        public final ClassSet parent;
        public final ClassNames precompiled;
        public final ClassNames generated;

        public ClassSet(ClassSet parent, String precompiled, String generated) {
            this.parent = parent;
            this.precompiled = new ClassNames(precompiled);
            this.generated = new ClassNames(generated);
            Preconditions.checkArgument(!generated.startsWith(precompiled), String.format("The new name of a class cannot start with the old name of a class, otherwise class renaming will cause problems.  Precompiled class name %s.  Generated class name %s", precompiled, generated));
        }

        public ClassSet getChild(String precompiled) {
            return new ClassSet(this, precompiled, precompiled.replace(this.precompiled.dot, this.generated.dot));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.generated == null ? 0 : this.generated.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.precompiled == null ? 0 : this.precompiled.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassSet other = (ClassSet)obj;
            if (this.generated == null ? other.generated != null : !this.generated.equals(other.generated)) {
                return false;
            }
            if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
                return false;
            }
            return !(this.precompiled == null ? other.precompiled != null : !this.precompiled.equals(other.precompiled));
        }
    }
}

