/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ByteCodeLoader {
    static final Logger logger = LoggerFactory.getLogger(ByteCodeLoader.class);
    private final LoadingCache<String, byte[]> byteCode = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(new ClassBytesCacheLoader());

    ByteCodeLoader() {
    }

    public byte[] getClassByteCodeFromPath(String path) throws ClassTransformationException, IOException {
        try {
            return this.byteCode.get(path);
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof ClassTransformationException) {
                throw (ClassTransformationException)c;
            }
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw new ClassTransformationException(c);
        }
    }

    private class ClassBytesCacheLoader
    extends CacheLoader<String, byte[]> {
        private ClassBytesCacheLoader() {
        }

        @Override
        public byte[] load(String path) throws ClassTransformationException, IOException {
            URL u = this.getClass().getResource(path);
            if (u == null) {
                throw new ClassTransformationException(String.format("Unable to find TemplateClass at path %s", path));
            }
            return Resources.toByteArray(u);
        }
    }
}

