/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.client;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.TopLevelAllocator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.BasicClientWithConnection;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.TransportCheck;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.UserClient;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillClient
implements Closeable,
ConnectionThrottle {
    static final Logger logger = LoggerFactory.getLogger(DrillClient.class);
    DrillConfig config;
    private UserClient client;
    private UserProtos.UserProperties props = null;
    private volatile ClusterCoordinator clusterCoordinator;
    private volatile boolean connected = false;
    private final BufferAllocator allocator;
    private int reconnectTimes;
    private int reconnectDelay;
    private boolean supportComplexTypes;
    private final boolean ownsZkConnection;
    private final boolean ownsAllocator;

    public DrillClient() {
        this(DrillConfig.create());
    }

    public DrillClient(DrillConfig config) {
        this(config, null);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator) {
        this(config, coordinator, null);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, BufferAllocator allocator) {
        this.ownsZkConnection = coordinator == null;
        this.ownsAllocator = allocator == null;
        this.allocator = allocator == null ? new TopLevelAllocator(config) : allocator;
        this.config = config;
        this.clusterCoordinator = coordinator;
        this.reconnectTimes = config.getInt("drill.exec.rpc.bit.server.retry.count");
        this.reconnectDelay = config.getInt("drill.exec.rpc.bit.server.retry.delay");
        this.supportComplexTypes = config.getBoolean("drill.client.supports-complex-types");
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.client.setAutoRead(enableAutoRead);
    }

    public synchronized void connect(String connect, Properties props) throws RpcException {
        Collection<CoordinationProtos.DrillbitEndpoint> endpoints;
        if (this.connected) {
            return;
        }
        if (this.ownsZkConnection) {
            try {
                this.clusterCoordinator = new ZKClusterCoordinator(this.config, connect);
                this.clusterCoordinator.start(10000L);
            }
            catch (Exception e) {
                throw new RpcException("Failure setting up ZK for client.", e);
            }
        }
        if (props != null) {
            UserProtos.UserProperties.Builder upBuilder = UserProtos.UserProperties.newBuilder();
            for (String key : props.stringPropertyNames()) {
                upBuilder.addProperties(UserProtos.Property.newBuilder().setKey(key).setValue(props.getProperty(key)));
            }
            this.props = upBuilder.build();
        }
        Preconditions.checkState(!(endpoints = this.clusterCoordinator.getAvailableEndpoints()).isEmpty(), "No DrillbitEndpoint can be found");
        CoordinationProtos.DrillbitEndpoint endpoint = endpoints.iterator().next();
        this.client = new UserClient(this.supportComplexTypes, this.allocator, TransportCheck.createEventLoopGroup(this.config.getInt("drill.exec.rpc.user.client.threads"), "Client-"));
        logger.debug("Connecting to server {}:{}", (Object)endpoint.getAddress(), (Object)endpoint.getUserPort());
        this.connect(endpoint);
        this.connected = true;
    }

    private void connect(CoordinationProtos.DrillbitEndpoint endpoint) throws RpcException {
        FutureHandler f = new FutureHandler();
        try {
            this.client.connect(f, endpoint, this.props);
            f.checkedGet();
        }
        catch (InterruptedException e) {
            throw new RpcException(e);
        }
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.ownsAllocator && this.allocator != null) {
            this.allocator.close();
        }
        if (this.ownsZkConnection) {
            try {
                this.clusterCoordinator.close();
            }
            catch (IOException e) {
                logger.warn("Error while closing Cluster Coordinator.", e);
            }
        }
        this.connected = false;
    }

    public DrillRpcFuture<GeneralRPCProtos.Ack> cancelQuery(UserBitShared.QueryId id) {
        logger.debug("Cancelling query {}", (Object)QueryIdHelper.getQueryId(id));
        return this.client.send(UserProtos.RpcType.CANCEL_QUERY, id, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public void runQuery(UserBitShared.QueryType type, String plan, UserResultsListener resultsListener) {
        this.client.submitQuery(resultsListener, UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build());
    }

    private class FutureHandler
    extends AbstractCheckedFuture<Void, RpcException>
    implements DrillRpcFuture<Void>,
    RpcConnectionHandler<BasicClientWithConnection.ServerConnection> {
        protected FutureHandler() {
            super(SettableFuture.create());
        }

        @Override
        public void connectionSucceeded(BasicClientWithConnection.ServerConnection connection) {
            this.getInner().set(null);
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            this.getInner().setException(new RpcException(String.format("Failure connecting to server. Failure of type %s.", type.name()), t));
        }

        private SettableFuture<Void> getInner() {
            return (SettableFuture)this.delegate();
        }

        @Override
        protected RpcException mapException(Exception e) {
            return RpcException.mapException(e);
        }
    }
}

