/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.cache.local;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.DataOutputOutputStream;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.cache.DistributedMap;
import org.apache.drill.exec.cache.DrillSerializable;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.TopLevelAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCache
implements DistributedCache {
    static final Logger logger = LoggerFactory.getLogger(LocalCache.class);
    private volatile ConcurrentMap<DistributedCache.CacheConfig<?, ?>, DistributedMap<?, ?>> maps;
    private volatile ConcurrentMap multiMaps;
    private volatile ConcurrentMap counters;
    private static final BufferAllocator allocator = new TopLevelAllocator(DrillConfig.create());
    private static final ObjectMapper mapper = DrillConfig.create().getMapper();

    @Override
    public void close() throws IOException {
    }

    @Override
    public void run() throws DrillbitStartupException {
        this.maps = Maps.newConcurrentMap();
        this.multiMaps = Maps.newConcurrentMap();
        this.counters = Maps.newConcurrentMap();
    }

    @Override
    public <K, V> DistributedMap<K, V> getMap(DistributedCache.CacheConfig<K, V> config) {
        DistributedMap m = (DistributedMap)this.maps.get(config);
        if (m == null) {
            this.maps.putIfAbsent(config, new LocalDistributedMapImpl<K, V>(config));
            return (DistributedMap)this.maps.get(config);
        }
        return m;
    }

    private static BytesHolder serialize(Object obj, DistributedCache.SerializationMode mode) {
        if (obj instanceof String) {
            return new BytesHolder(((String)obj).getBytes(Charsets.UTF_8));
        }
        try {
            switch (mode) {
                case DRILL_SERIALIZIABLE: {
                    ByteArrayDataOutput out = ByteStreams.newDataOutput();
                    OutputStream outputStream = DataOutputOutputStream.constructOutputStream(out);
                    ((DrillSerializable)obj).writeToStream(outputStream);
                    outputStream.flush();
                    return new BytesHolder(out.toByteArray());
                }
                case JACKSON: {
                    ByteArrayDataOutput out = ByteStreams.newDataOutput();
                    out.write(mapper.writeValueAsBytes(obj));
                    return new BytesHolder(out.toByteArray());
                }
                case PROTOBUF: {
                    return new BytesHolder(((Message)obj).toByteArray());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new UnsupportedOperationException();
    }

    private static <V> V deserialize(BytesHolder b, DistributedCache.SerializationMode mode, Class<V> clazz) {
        byte[] bytes = b.bytes;
        try {
            if (clazz == String.class) {
                return (V)new String(bytes, Charsets.UTF_8);
            }
            switch (mode) {
                case DRILL_SERIALIZIABLE: {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                    V obj = clazz.getConstructor(BufferAllocator.class).newInstance(allocator);
                    ((DrillSerializable)obj).readFromStream(inputStream);
                    return obj;
                }
                case JACKSON: {
                    return mapper.readValue(bytes, clazz);
                }
                case PROTOBUF: {
                    Parser parser = null;
                    for (Field f : clazz.getFields()) {
                        if (!f.getName().equals("PARSER") || !Modifier.isStatic(f.getModifiers())) continue;
                        parser = (Parser)f.get(null);
                    }
                    if (parser == null) {
                        throw new UnsupportedOperationException(String.format("Unable to find parser for class %s.", clazz.getName()));
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                    return (V)parser.parseFrom(inputStream);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new UnsupportedOperationException();
    }

    public static class LocalDistributedMapImpl<K, V>
    implements DistributedMap<K, V> {
        protected ConcurrentMap<BytesHolder, BytesHolder> m = Maps.newConcurrentMap();
        protected DistributedCache.CacheConfig<K, V> config;

        public LocalDistributedMapImpl(DistributedCache.CacheConfig<K, V> config) {
            this.config = config;
        }

        @Override
        public V get(K key) {
            BytesHolder b = (BytesHolder)this.m.get(LocalCache.serialize(key, this.config.getMode()));
            if (b == null) {
                return null;
            }
            return (V)LocalCache.deserialize(b, this.config.getMode(), this.config.getValueClass());
        }

        @Override
        public Iterable<Map.Entry<K, V>> getLocalEntries() {
            return new Iterable<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new DeserializingTransformer(LocalDistributedMapImpl.this.m.entrySet().iterator());
                }
            };
        }

        @Override
        public Future<V> put(K key, V value) {
            this.m.put(LocalCache.serialize(key, this.config.getMode()), LocalCache.serialize(value, this.config.getMode()));
            return new LocalCacheFuture<V>(value);
        }

        private class DeserializingTransformer
        implements Iterator<Map.Entry<K, V>> {
            private Iterator<Map.Entry<BytesHolder, BytesHolder>> inner;

            public DeserializingTransformer(Iterator<Map.Entry<BytesHolder, BytesHolder>> inner) {
                this.inner = inner;
            }

            @Override
            public boolean hasNext() {
                return this.inner.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.newEntry(this.inner.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Map.Entry<K, V> newEntry(final Map.Entry<BytesHolder, BytesHolder> input) {
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return LocalCache.deserialize((BytesHolder)input.getKey(), LocalDistributedMapImpl.this.config.getMode(), LocalDistributedMapImpl.this.config.getKeyClass());
                    }

                    @Override
                    public V getValue() {
                        return LocalCache.deserialize((BytesHolder)input.getValue(), LocalDistributedMapImpl.this.config.getMode(), LocalDistributedMapImpl.this.config.getValueClass());
                    }

                    @Override
                    public V setValue(V value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }

    public static class LocalCacheFuture<V>
    implements Future<V> {
        V value;

        public LocalCacheFuture(V value) {
            this.value = value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.value;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.value;
        }
    }

    private static class BytesHolder {
        final byte[] bytes;

        public BytesHolder(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BytesHolder other = (BytesHolder)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

