/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.cache.infinispan;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.cache.DistributedMap;
import org.apache.drill.exec.cache.SerializationDefinition;
import org.apache.drill.exec.cache.infinispan.JacksonAdvancedExternalizer;
import org.apache.drill.exec.cache.infinispan.ProtobufAdvancedExternalizer;
import org.apache.drill.exec.cache.infinispan.VAAdvancedExternalizer;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.JChannel;
import org.jgroups.blocks.atomic.CounterService;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.COUNTER;
import org.jgroups.protocols.FRAG2;
import org.jgroups.stack.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICache
implements DistributedCache {
    static final Logger logger = LoggerFactory.getLogger(ICache.class);
    private EmbeddedCacheManager manager;
    private ForkChannel cacheChannel;
    private final CounterService counters;
    private final boolean local;
    private volatile ConcurrentMap localCounters;

    public ICache(DrillConfig config, BufferAllocator allocator, boolean local) throws Exception {
        String clusterName = config.getString("drill.exec.cluster-id");
        this.local = local;
        CacheMode mode = local ? CacheMode.LOCAL : CacheMode.DIST_SYNC;
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        if (!local) {
            gcb.transport().defaultTransport().clusterName(clusterName);
        }
        gcb.serialization().addAdvancedExternalizer((AdvancedExternalizer)new VAAdvancedExternalizer(allocator)).addAdvancedExternalizer(new JacksonAdvancedExternalizer(SerializationDefinition.OPTION, config.getMapper())).addAdvancedExternalizer(new JacksonAdvancedExternalizer(SerializationDefinition.STORAGE_PLUGINS, config.getMapper())).addAdvancedExternalizer(new ProtobufAdvancedExternalizer<BitControl.FragmentStatus>(SerializationDefinition.FRAGMENT_STATUS, BitControl.FragmentStatus.PARSER)).addAdvancedExternalizer(new ProtobufAdvancedExternalizer<ExecProtos.FragmentHandle>(SerializationDefinition.FRAGMENT_HANDLE, ExecProtos.FragmentHandle.PARSER)).addAdvancedExternalizer(new ProtobufAdvancedExternalizer<BitControl.PlanFragment>(SerializationDefinition.PLAN_FRAGMENT, BitControl.PlanFragment.PARSER)).build();
        Configuration c = new ConfigurationBuilder().clustering().cacheMode(mode).storeAsBinary().enable().build();
        this.manager = new DefaultCacheManager(gcb.build(), c);
        if (!local) {
            JGroupsTransport transport = (JGroupsTransport)this.manager.getCache("first").getAdvancedCache().getRpcManager().getTransport();
            this.cacheChannel = new ForkChannel(transport.getChannel(), "drill-stack", "drill-hijacker", true, 1, FRAG2.class, new Protocol[]{new COUNTER()});
            this.counters = new CounterService((JChannel)this.cacheChannel);
        } else {
            this.cacheChannel = null;
            this.counters = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.stop();
    }

    @Override
    public void run() throws DrillbitStartupException {
        try {
            if (this.local) {
                this.localCounters = Maps.newConcurrentMap();
                this.manager.start();
            } else {
                this.cacheChannel.connect("c1");
            }
        }
        catch (Exception e) {
            throw new DrillbitStartupException("Failure while trying to set up JGroups.");
        }
    }

    @Override
    public <K, V> DistributedMap<K, V> getMap(DistributedCache.CacheConfig<K, V> config) {
        Cache c = this.manager.getCache(config.getName());
        return new IMap<K, V>(c, config);
    }

    private class IMap<K, V>
    implements DistributedMap<K, V> {
        private Cache<K, V> cache;
        private DistributedCache.CacheConfig<K, V> config;

        public IMap(Cache<K, V> cache, DistributedCache.CacheConfig<K, V> config) {
            this.cache = cache;
            this.config = config;
        }

        @Override
        public Iterable<Map.Entry<K, V>> getLocalEntries() {
            return this.cache.entrySet();
        }

        @Override
        public V get(K key) {
            return (V)this.cache.get(key);
        }

        @Override
        public Future<V> put(K key, V value) {
            return this.cache.putAsync(key, value);
        }
    }
}

