/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.drill.common.util.DataInputInputStream;
import org.apache.drill.common.util.DataOutputOutputStream;
import org.apache.drill.exec.cache.DrillSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LoopedAbstractDrillSerializable
implements DrillSerializable {
    static final Logger logger = LoggerFactory.getLogger(LoopedAbstractDrillSerializable.class);

    LoopedAbstractDrillSerializable() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeToStream(baos);
        byte[] ba = baos.toByteArray();
        out.writeInt(ba.length);
        out.write(ba);
    }

    public void read(DataInput input) throws IOException {
        this.readFromStream(DataInputInputStream.constructInputStream(input));
    }

    public void write(DataOutput output) throws IOException {
        this.writeToStream(DataOutputOutputStream.constructOutputStream(output));
    }

    @Override
    public void readFromStream(InputStream input) throws IOException {
        this.read(new DataInputStream(input));
    }

    @Override
    public void writeToStream(OutputStream output) throws IOException {
        this.write(new DataOutputStream(output));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        this.readFromStream(new ByteArrayInputStream(bytes));
    }
}

