/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.drill.common.logical.UnexpectedOperatorType;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.logical.data.SinkOperator;

public abstract class SingleInputOperator
extends LogicalOperatorBase {
    private LogicalOperator input;

    @JsonProperty(value="input")
    public LogicalOperator getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(LogicalOperator input) {
        if (input instanceof SinkOperator) {
            throw new UnexpectedOperatorType("You have set the input of a sink node of type [" + input.getClass().getSimpleName() + "] as the input for another node of type [" + this.getClass().getSimpleName() + "].  This is invalid.");
        }
        this.input = input;
        input.registerAsSubscriber(this);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.input);
    }
}

