/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.AbstractSingleBuilder;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.SingleInputOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.eigenbase.rel.RelFieldCollation;

@JsonTypeName(value="order")
public class Order
extends SingleInputOperator {
    private final Ordering[] orderings;
    private final FieldReference within;

    @JsonCreator
    public Order(@JsonProperty(value="within") FieldReference within, Ordering ... orderings) {
        this.orderings = orderings;
        this.within = within;
    }

    public Ordering[] getOrderings() {
        return this.orderings;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitOrder(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.getInput());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSingleBuilder<Order, Builder> {
        private List<Ordering> orderings = Lists.newArrayList();
        private FieldReference within;

        public Builder addOrdering(RelFieldCollation.Direction direction, LogicalExpression e, RelFieldCollation.NullDirection collation) {
            this.orderings.add(new Ordering(direction, e, collation));
            return this;
        }

        @Override
        public Order internalBuild() {
            return new Order(this.within, this.orderings.toArray(new Ordering[this.orderings.size()]));
        }
    }

    public static class Ordering {
        private final RelFieldCollation.Direction direction;
        private final LogicalExpression expr;
        private final RelFieldCollation.NullDirection nulls;

        public Ordering(RelFieldCollation.Direction direction, LogicalExpression e, RelFieldCollation.NullDirection nullCollation) {
            this.expr = e;
            this.nulls = nullCollation;
            this.direction = direction;
        }

        public Ordering(RelFieldCollation.Direction direction, LogicalExpression e) {
            this(direction, e, RelFieldCollation.NullDirection.FIRST);
        }

        @JsonIgnore
        public RelFieldCollation.Direction getDirection() {
            return this.direction;
        }

        public LogicalExpression getExpr() {
            return this.expr;
        }
    }
}

