/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.drill.common.JSONOptions;

public class PlanProperties {
    public PlanType type;
    public int version;
    public Generator generator;
    public Generator.ResultMode resultMode;
    public JSONOptions options;
    public int queue;

    private PlanProperties(@JsonProperty(value="version") int version, @JsonProperty(value="generator") Generator generator, @JsonProperty(value="type") PlanType type, @JsonProperty(value="mode") Generator.ResultMode resultMode, @JsonProperty(value="options") JSONOptions options, @JsonProperty(value="queue") int queue) {
        this.version = version;
        this.queue = queue;
        this.generator = generator;
        this.type = type;
        this.resultMode = resultMode == null ? Generator.ResultMode.EXEC : resultMode;
        this.options = options;
    }

    public static PlanPropertiesBuilder builder() {
        return new PlanPropertiesBuilder();
    }

    public static class PlanPropertiesBuilder {
        private int version;
        private Generator generator;
        private PlanType type;
        private Generator.ResultMode mode = Generator.ResultMode.EXEC;
        private JSONOptions options;
        private int queueNumber = 0;

        public PlanPropertiesBuilder type(PlanType type) {
            this.type = type;
            return this;
        }

        public PlanPropertiesBuilder version(int version) {
            this.version = version;
            return this;
        }

        public PlanPropertiesBuilder generator(String type, String info) {
            this.generator = new Generator(type, info);
            return this;
        }

        public PlanPropertiesBuilder resultMode(Generator.ResultMode mode) {
            this.mode = mode;
            return this;
        }

        public PlanPropertiesBuilder options(JSONOptions options) {
            this.options = options;
            return this;
        }

        public PlanPropertiesBuilder generator(Generator generator) {
            this.generator = generator;
            return this;
        }

        public PlanProperties build() {
            return new PlanProperties(this.version, this.generator, this.type, this.mode, this.options, this.queueNumber);
        }
    }

    public static class Generator {
        public String type;
        public String info;

        private Generator(@JsonProperty(value="type") String type, @JsonProperty(value="info") String info) {
            this.type = type;
            this.info = info;
        }

        public static enum ResultMode {
            EXEC,
            LOGICAL,
            PHYSICAL;

        }
    }

    public static enum PlanType {
        APACHE_DRILL_LOGICAL,
        APACHE_DRILL_PHYSICAL;

    }
}

