/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.graph;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.graph.AdjacencyList;
import org.apache.drill.common.graph.GraphValue;
import org.apache.drill.common.graph.GraphVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdjacencyListBuilder<V extends GraphValue<V>>
implements GraphVisitor<V> {
    static final Logger logger = LoggerFactory.getLogger(AdjacencyListBuilder.class);
    private Map<V, AdjacencyList.Node> ops = new HashMap<V, AdjacencyList.Node>();
    private final AdjacencyList<V> parent;

    public AdjacencyListBuilder(AdjacencyList<V> parent) {
        this.parent = parent;
    }

    @Override
    public boolean enter(V o) {
        this.visit(o);
        return true;
    }

    @Override
    public void leave(V o) {
    }

    @Override
    public boolean visit(V o) {
        if (o == null) {
            throw new IllegalArgumentException("Null operator.");
        }
        if (!this.ops.containsKey(o)) {
            this.ops.put((AdjacencyList.Node)o, this.parent.getNewNode(o));
            return true;
        }
        return true;
    }

    public AdjacencyList<V> getAdjacencyList() {
        AdjacencyList a = new AdjacencyList();
        for (AdjacencyList.Node from : this.ops.values()) {
            for (GraphValue t : from.getNodeValue()) {
                AdjacencyList.Node to = this.ops.get(t);
                a.addEdge(from, to, 0);
            }
        }
        a.fix(true);
        return a;
    }
}

