/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression.fn;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;

public class CastFunctions {
    private static Map<TypeProtos.MinorType, String> TYPE2FUNC = new HashMap<TypeProtos.MinorType, String>();

    public static String getCastFunc(TypeProtos.MinorType targetMinorType) {
        String func = TYPE2FUNC.get(targetMinorType);
        if (func != null) {
            return func;
        }
        throw new RuntimeException(String.format("cast function for type %s is not defined", targetMinorType.name()));
    }

    static {
        TYPE2FUNC.put(TypeProtos.MinorType.BIGINT, "castBIGINT");
        TYPE2FUNC.put(TypeProtos.MinorType.INT, "castINT");
        TYPE2FUNC.put(TypeProtos.MinorType.BIT, "castBIT");
        TYPE2FUNC.put(TypeProtos.MinorType.TINYINT, "castTINYINT");
        TYPE2FUNC.put(TypeProtos.MinorType.FLOAT4, "castFLOAT4");
        TYPE2FUNC.put(TypeProtos.MinorType.FLOAT8, "castFLOAT8");
        TYPE2FUNC.put(TypeProtos.MinorType.VARCHAR, "castVARCHAR");
        TYPE2FUNC.put(TypeProtos.MinorType.VAR16CHAR, "castVAR16CHAR");
        TYPE2FUNC.put(TypeProtos.MinorType.VARBINARY, "castVARBINARY");
        TYPE2FUNC.put(TypeProtos.MinorType.DATE, "castDATE");
        TYPE2FUNC.put(TypeProtos.MinorType.TIME, "castTIME");
        TYPE2FUNC.put(TypeProtos.MinorType.TIMESTAMP, "castTIMESTAMP");
        TYPE2FUNC.put(TypeProtos.MinorType.TIMESTAMPTZ, "castTIMESTAMPTZ");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVALDAY, "castINTERVALDAY");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVALYEAR, "castINTERVALYEAR");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVAL, "castINTERVAL");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL9, "castDECIMAL9");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL18, "castDECIMAL18");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL28SPARSE, "castDECIMAL28SPARSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL28DENSE, "castDECIMAL28DENSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL38SPARSE, "castDECIMAL38SPARSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL38DENSE, "castDECIMAL38DENSE");
    }
}

