/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.visitors.ExpressionValidationError;

public class ErrorCollectorImpl
implements ErrorCollector {
    List<ExpressionValidationError> errors = Lists.newArrayList();

    private String addExpr(ExpressionPosition expr, String message) {
        return String.format("Error in expression at index %d.  Error: %s.  Full expression: %s.", expr.getCharIndex(), message, expr.getExpression());
    }

    @Override
    public void addGeneralError(ExpressionPosition expr, String s) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, s)));
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public String toErrorString() {
        return "\n" + Joiner.on("\n").join(this.errors);
    }

    public String toString() {
        return this.toErrorString();
    }
}

