/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.queue;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.curator.utils.CloseableUtils;
import org.slf4j.Logger;

public class QueueSharder<U, T extends QueueBase<U>>
implements Closeable {
    private final Logger log;
    private final ConcurrentMap<String, T> queues;
    private final AtomicReference<State> state;
    private final LeaderLatch leaderLatch;
    private final ExecutorService service;

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.service.shutdownNow();
            CloseableUtils.closeQuietly(this.leaderLatch);
            for (QueueBase queue : this.queues.values()) {
                try {
                    queue.close();
                }
                catch (IOException e) {
                    this.log.error("Closing a queue", e);
                }
            }
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

