/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.nodes;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CreateModable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;

public class PersistentEphemeralNode
implements Closeable {
    private final Logger log;
    private final CuratorFramework client;
    private final CreateModable<ACLBackgroundPathAndBytesable<String>> createMethod;
    private final AtomicReference<String> nodePath;
    private final String basePath;
    private final Mode mode;
    private final AtomicReference<byte[]> data;
    private final AtomicReference<State> state;
    private final BackgroundCallback backgroundCallback;
    private final ConnectionStateListener connectionStateListener;

    @Override
    public void close() throws IOException {
        if (!this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            return;
        }
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        try {
            this.deleteNode();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void deleteNode() throws Exception {
        String localNodePath = this.nodePath.getAndSet(null);
        if (localNodePath != null) {
            try {
                this.client.delete().guaranteed().forPath(localNodePath);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (Exception e) {
                this.log.error("Deleting node: " + localNodePath, e);
                throw e;
            }
        }
    }

    private void createNode() {
        if (!this.isActive()) {
            return;
        }
        try {
            String existingPath = this.nodePath.get();
            String createPath = existingPath != null ? existingPath : this.basePath;
            ((PathAndBytesable)this.createMethod.withMode(this.mode.getCreateMode(existingPath != null)).inBackground(this.backgroundCallback)).forPath(createPath, this.data.get());
        }
        catch (Exception e) {
            this.log.error("Creating node. BasePath: " + this.basePath, e);
            throw new RuntimeException(e);
        }
    }

    private boolean isActive() {
        return this.state.get() == State.STARTED;
    }

    public static enum Mode {
        EPHEMERAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return CreateMode.EPHEMERAL;
            }

            @Override
            protected boolean isProtected() {
                return false;
            }
        }
        ,
        EPHEMERAL_SEQUENTIAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return pathIsSet ? CreateMode.EPHEMERAL : CreateMode.EPHEMERAL_SEQUENTIAL;
            }

            @Override
            protected boolean isProtected() {
                return false;
            }
        }
        ,
        PROTECTED_EPHEMERAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return CreateMode.EPHEMERAL;
            }

            @Override
            protected boolean isProtected() {
                return true;
            }
        }
        ,
        PROTECTED_EPHEMERAL_SEQUENTIAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return pathIsSet ? CreateMode.EPHEMERAL : CreateMode.EPHEMERAL_SEQUENTIAL;
            }

            @Override
            protected boolean isProtected() {
                return true;
            }
        };


        protected abstract CreateMode getCreateMode(boolean var1);

        protected abstract boolean isProtected();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

