/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.LockInternals;
import org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;

public class InterProcessMutex {
    private final LockInternals internals;
    private final String basePath;
    private final ConcurrentMap<Thread, LockData> threadData = Maps.newConcurrentMap();

    public InterProcessMutex(CuratorFramework client, String path) {
        this(client, path, "lock-", 1, new StandardLockInternalsDriver());
    }

    public void acquire() throws Exception {
        if (!this.internalLock(-1L, null)) {
            throw new IOException("Lost connection while trying to acquire lock: " + this.basePath);
        }
    }

    public boolean acquire(long time, TimeUnit unit) throws Exception {
        return this.internalLock(time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData == null) {
            throw new IllegalMonitorStateException("You do not own the lock: " + this.basePath);
        }
        int newLockCount = lockData.lockCount.decrementAndGet();
        if (newLockCount > 0) {
            return;
        }
        if (newLockCount < 0) {
            throw new IllegalMonitorStateException("Lock count has gone negative for lock: " + this.basePath);
        }
        try {
            this.internals.releaseLock(lockData.lockPath);
        }
        finally {
            this.threadData.remove(currentThread);
        }
    }

    InterProcessMutex(CuratorFramework client, String path, String lockName, int maxLeases, LockInternalsDriver driver) {
        this.basePath = path;
        this.internals = new LockInternals(client, driver, path, lockName, maxLeases);
    }

    protected byte[] getLockNodeBytes() {
        return null;
    }

    private boolean internalLock(long time, TimeUnit unit) throws Exception {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData != null) {
            lockData.lockCount.incrementAndGet();
            return true;
        }
        String lockPath = this.internals.attemptLock(time, unit, this.getLockNodeBytes());
        if (lockPath != null) {
            LockData newLockData = new LockData(currentThread, lockPath);
            this.threadData.put(currentThread, newLockData);
            return true;
        }
        return false;
    }

    private static class LockData {
        final Thread owningThread;
        final String lockPath;
        final AtomicInteger lockCount = new AtomicInteger(1);

        private LockData(Thread owningThread, String lockPath) {
            this.owningThread = owningThread;
            this.lockPath = lockPath;
        }
    }
}

