/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.utils.CloseableUtils;

public class ChildReaper
implements Closeable {
    private final Reaper reaper;
    private final AtomicReference<State> state;
    private volatile Future<?> task;

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CloseableUtils.closeQuietly(this.reaper);
            this.task.cancel(true);
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

