/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.CursorableLinkedList;
import org.apache.commons.pool.impl.EvictionTimer;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class GenericObjectPool
extends BaseObjectPool {
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private volatile boolean _testOnBorrow = false;
    private volatile boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private long _softMinEvictableIdleTimeMillis = -1L;
    private boolean _lifo = true;
    private CursorableLinkedList _pool = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;
    private Evictor _evictor = null;
    private int _numInternalProcessing = 0;
    private LinkedList _allocationQueue = new LinkedList();

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, -1L);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, long softMinEvictableIdleTimeMillis) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, softMinEvictableIdleTimeMillis, true);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, long softMinEvictableIdleTimeMillis, boolean lifo) {
        this._factory = factory;
        this._maxActive = maxActive;
        this._lifo = lifo;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._minIdle = minIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._pool = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        this.allocate();
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
        this.allocate();
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        this.allocate();
    }

    public synchronized void setMinIdle(int minIdle) {
        this._minIdle = minIdle;
        this.allocate();
    }

    public synchronized int getMinIdle() {
        return this._minIdle;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this._softMinEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object borrowObject() throws Exception {
        long maxWait;
        byte whenExhaustedAction;
        long starttime = System.currentTimeMillis();
        Latch latch = new Latch();
        Object object = this;
        synchronized (object) {
            whenExhaustedAction = this._whenExhaustedAction;
            maxWait = this._maxWait;
            this._allocationQueue.add(latch);
            this.allocate();
        }
        block44: while (true) {
            block57: {
                object = this;
                synchronized (object) {
                    this.assertOpen();
                }
                if (latch.getPair() != null || latch.mayCreate()) break block57;
                switch (whenExhaustedAction) {
                    case 2: {
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() == null && !latch.mayCreate()) {
                                this._allocationQueue.remove(latch);
                                ++this._numInternalProcessing;
                            }
                            break;
                        }
                    }
                    case 0: {
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() != null || latch.mayCreate()) {
                                break;
                            }
                            this._allocationQueue.remove(latch);
                            throw new NoSuchElementException("Pool exhausted");
                        }
                    }
                    case 1: {
                        try {
                            object = latch;
                            synchronized (object) {
                                if (latch.getPair() != null || latch.mayCreate()) {
                                    break;
                                }
                                if (maxWait <= 0L) {
                                    latch.wait();
                                } else {
                                    long elapsed = System.currentTimeMillis() - starttime;
                                    long waitTime = maxWait - elapsed;
                                    if (waitTime > 0L) {
                                        latch.wait(waitTime);
                                    }
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        if (maxWait <= 0L || System.currentTimeMillis() - starttime < maxWait) continue block44;
                        GenericObjectPool e = this;
                        synchronized (e) {
                            if (latch.getPair() != null || latch.mayCreate()) {
                                break;
                            }
                            this._allocationQueue.remove(latch);
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("WhenExhaustedAction property " + whenExhaustedAction + " not recognized.");
                    }
                }
            }
            boolean newlyCreated = false;
            if (null == latch.getPair()) {
                Object obj;
                try {
                    obj = this._factory.makeObject();
                    latch.setPair(new GenericKeyedObjectPool.ObjectTimestampPair(obj));
                    newlyCreated = true;
                }
                finally {
                    if (!newlyCreated) {
                        obj = this;
                        synchronized (obj) {
                            --this._numInternalProcessing;
                            this.allocate();
                        }
                    }
                }
            }
            try {
                this._factory.activateObject(((Latch)latch).getPair().value);
                if (this._testOnBorrow && !this._factory.validateObject(((Latch)latch).getPair().value)) {
                    throw new Exception("ValidateObject failed");
                }
                GenericObjectPool obj = this;
                synchronized (obj) {
                    --this._numInternalProcessing;
                    ++this._numActive;
                    return ((Latch)latch).getPair().value;
                }
            }
            catch (Throwable e) {
                try {
                    this._factory.destroyObject(((Latch)latch).getPair().value);
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                    if (!newlyCreated) {
                        latch.reset();
                        this._allocationQueue.add(0, latch);
                    }
                    this.allocate();
                }
                if (newlyCreated) throw new NoSuchElementException("Could not create a validated object, cause: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void allocate() {
        Latch latch;
        Latch latch2;
        if (this.isClosed()) {
            return;
        }
        while (!this._pool.isEmpty() && !this._allocationQueue.isEmpty()) {
            latch2 = (Latch)this._allocationQueue.removeFirst();
            latch2.setPair((GenericKeyedObjectPool.ObjectTimestampPair)this._pool.removeFirst());
            ++this._numInternalProcessing;
            latch = latch2;
            synchronized (latch) {
                latch2.notify();
            }
        }
        while (!(this._allocationQueue.isEmpty() || this._maxActive >= 0 && this._numActive + this._numInternalProcessing >= this._maxActive)) {
            latch2 = (Latch)this._allocationQueue.removeFirst();
            latch2.setMayCreate(true);
            ++this._numInternalProcessing;
            latch = latch2;
            synchronized (latch) {
                latch2.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object obj) throws Exception {
        try {
            if (this._factory != null) {
                this._factory.destroyObject(obj);
            }
        }
        finally {
            GenericObjectPool genericObjectPool = this;
            synchronized (genericObjectPool) {
                --this._numActive;
                this.allocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            GenericObjectPool genericObjectPool;
            try {
                this._factory.destroyObject(((GenericKeyedObjectPool.ObjectTimestampPair)it.next()).value);
            }
            catch (Exception exception) {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                    this.allocate();
                }
            }
            finally {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                    this.allocate();
                }
            }
        }
    }

    public synchronized int getNumActive() {
        return this._numActive;
    }

    public synchronized int getNumIdle() {
        return this._pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        block7: {
            try {
                this.addObjectToPool(obj, true);
            }
            catch (Exception e) {
                if (this._factory == null) break block7;
                try {
                    this._factory.destroyObject(obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                    this.allocate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToPool(Object obj, boolean decrementNumActive) throws Exception {
        boolean success = true;
        if (this._testOnReturn && !this._factory.validateObject(obj)) {
            success = false;
        } else {
            this._factory.passivateObject(obj);
        }
        boolean shouldDestroy = !success;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this.isClosed()) {
                shouldDestroy = true;
            } else if (this._maxIdle >= 0 && this._pool.size() >= this._maxIdle) {
                shouldDestroy = true;
            } else if (success) {
                if (this._lifo) {
                    this._pool.addFirst(new GenericKeyedObjectPool.ObjectTimestampPair(obj));
                } else {
                    this._pool.addLast(new GenericKeyedObjectPool.ObjectTimestampPair(obj));
                }
                if (decrementNumActive) {
                    --this._numActive;
                }
                this.allocate();
            }
        }
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (decrementNumActive) {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                    this.allocate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        ArrayList toDestroy = new ArrayList();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.assertOpen();
            if (0 < this.getNumActive()) {
                throw new IllegalStateException("Objects are already active");
            }
            toDestroy.addAll(this._pool);
            this._numInternalProcessing += this._pool._size;
            this._pool.clear();
            this._factory = factory;
        }
        this.destroy(toDestroy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() throws Exception {
        this.assertOpen();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this._pool.isEmpty()) {
                return;
            }
            if (null == this._evictionCursor) {
                this._evictionCursor = this._pool.cursor(this._lifo ? this._pool.size() : 0);
            }
        }
        int m = this.getNumTests();
        for (int i = 0; i < m; ++i) {
            GenericKeyedObjectPool.ObjectTimestampPair pair;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                if (this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) {
                    this._evictionCursor.close();
                    this._evictionCursor = this._pool.cursor(this._lifo ? this._pool.size() : 0);
                }
                pair = this._lifo ? (GenericKeyedObjectPool.ObjectTimestampPair)this._evictionCursor.previous() : (GenericKeyedObjectPool.ObjectTimestampPair)this._evictionCursor.next();
                this._evictionCursor.remove();
                ++this._numInternalProcessing;
            }
            boolean removeObject = false;
            long idleTimeMilis = System.currentTimeMillis() - pair.tstamp;
            if (this.getMinEvictableIdleTimeMillis() > 0L && idleTimeMilis > this.getMinEvictableIdleTimeMillis()) {
                removeObject = true;
            } else if (this.getSoftMinEvictableIdleTimeMillis() > 0L && idleTimeMilis > this.getSoftMinEvictableIdleTimeMillis() && this.getNumIdle() + 1 > this.getMinIdle()) {
                removeObject = true;
            }
            if (this.getTestWhileIdle() && !removeObject) {
                boolean active = false;
                try {
                    this._factory.activateObject(pair.value);
                    active = true;
                }
                catch (Exception e) {
                    removeObject = true;
                }
                if (active) {
                    if (!this._factory.validateObject(pair.value)) {
                        removeObject = true;
                    } else {
                        try {
                            this._factory.passivateObject(pair.value);
                        }
                        catch (Exception e) {
                            removeObject = true;
                        }
                    }
                }
            }
            if (removeObject) {
                try {
                    this._factory.destroyObject(pair.value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            GenericObjectPool genericObjectPool3 = this;
            synchronized (genericObjectPool3) {
                if (!removeObject) {
                    this._evictionCursor.add(pair);
                    if (this._lifo) {
                        this._evictionCursor.previous();
                    }
                }
                --this._numInternalProcessing;
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMinIdle() throws Exception {
        int objectDeficit = this.calculateDeficit(false);
        for (int j = 0; j < objectDeficit && this.calculateDeficit(true) > 0; ++j) {
            try {
                this.addObject();
                continue;
            }
            finally {
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                    this.allocate();
                }
            }
        }
    }

    private synchronized int calculateDeficit(boolean incrementInternal) {
        int objectDeficit = this.getMinIdle() - this.getNumIdle();
        if (this._maxActive > 0) {
            int growLimit = Math.max(0, this.getMaxActive() - this.getNumActive() - this.getNumIdle() - this._numInternalProcessing);
            objectDeficit = Math.min(objectDeficit, growLimit);
        }
        if (incrementInternal && objectDeficit > 0) {
            ++this._numInternalProcessing;
        }
        return objectDeficit;
    }

    public void addObject() throws Exception {
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        Object obj = this._factory.makeObject();
        try {
            this.assertOpen();
            this.addObjectToPool(obj, false);
        }
        catch (IllegalStateException ex) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected synchronized void startEvictor(long delay) {
        if (null != this._evictor) {
            EvictionTimer.cancel(this._evictor);
            this._evictor = null;
        }
        if (delay > 0L) {
            this._evictor = new Evictor();
            EvictionTimer.schedule(this._evictor, delay, delay);
        }
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return Math.min(this._numTestsPerEvictionRun, this._pool.size());
        }
        return (int)Math.ceil((double)this._pool.size() / Math.abs((double)this._numTestsPerEvictionRun));
    }

    private static final class Latch {
        private GenericKeyedObjectPool.ObjectTimestampPair _pair;
        private boolean _mayCreate = false;

        private Latch() {
        }

        private synchronized GenericKeyedObjectPool.ObjectTimestampPair getPair() {
            return this._pair;
        }

        private synchronized void setPair(GenericKeyedObjectPool.ObjectTimestampPair pair) {
            this._pair = pair;
        }

        private synchronized boolean mayCreate() {
            return this._mayCreate;
        }

        private synchronized void setMayCreate(boolean mayCreate) {
            this._mayCreate = mayCreate;
        }

        private synchronized void reset() {
            this._pair = null;
            this._mayCreate = false;
        }
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        public void run() {
            try {
                GenericObjectPool.this.evict();
            }
            catch (Exception e) {
            }
            catch (OutOfMemoryError oome) {
                oome.printStackTrace(System.err);
            }
            try {
                GenericObjectPool.this.ensureMinIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

