/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected volatile boolean defaultAutoCommit = true;
    protected transient Boolean defaultReadOnly = null;
    protected volatile int defaultTransactionIsolation = -1;
    protected volatile String defaultCatalog = null;
    protected String driverClassName = null;
    protected ClassLoader driverClassLoader = null;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean poolPreparedStatements = false;
    protected int maxOpenPreparedStatements = -1;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;
    protected volatile String password = null;
    protected String url = null;
    protected String username = null;
    protected volatile String validationQuery = null;
    protected volatile int validationQueryTimeout = -1;
    protected volatile List connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private volatile boolean restartNeeded = false;
    protected volatile GenericObjectPool connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected volatile DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    private AbandonedConfig abandonedConfig;
    protected boolean closed;

    public synchronized void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName != null && driverClassName.trim().length() > 0 ? driverClassName : null;
        this.restartNeeded = true;
    }

    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(testOnBorrow);
        }
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(testOnReturn);
        }
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(testWhileIdle);
        }
    }

    public void setPassword(String password) {
        this.password = password;
        this.restartNeeded = true;
    }

    public synchronized void setUrl(String url) {
        this.url = url;
        this.restartNeeded = true;
    }

    public void setUsername(String username) {
        this.username = username;
        this.restartNeeded = true;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
        this.logWriter = logWriter;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        ConnectionFactory driverConnectionFactory = this.createConnectionFactory();
        this.createConnectionPool();
        GenericKeyedObjectPoolFactory statementPoolFactory = null;
        if (this.isPoolPreparedStatements()) {
            statementPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, this.maxOpenPreparedStatements);
        }
        this.createPoolableConnectionFactory(driverConnectionFactory, (KeyedObjectPoolFactory)((Object)statementPoolFactory), this.abandonedConfig);
        this.createDataSourceInstance();
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.connectionPool.addObject();
            }
        }
        catch (Exception e) {
            throw new SQLNestedException("Error preloading the connection pool", e);
        }
        return this.dataSource;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String user;
        Class<?> driverFromCCL;
        block16: {
            driverFromCCL = null;
            if (this.driverClassName != null) {
                try {
                    try {
                        if (this.driverClassLoader == null) {
                            Class.forName(this.driverClassName);
                            break block16;
                        }
                        Class.forName(this.driverClassName, true, this.driverClassLoader);
                    }
                    catch (ClassNotFoundException cnfe) {
                        driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
                    }
                }
                catch (Throwable t) {
                    String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                    this.logWriter.println(message);
                    t.printStackTrace(this.logWriter);
                    throw new SQLNestedException(message, t);
                }
            }
        }
        Driver driver = null;
        try {
            if (driverFromCCL == null) {
                driver = DriverManager.getDriver(this.url);
            } else {
                driver = (Driver)driverFromCCL.newInstance();
                if (!driver.acceptsURL(this.url)) {
                    throw new SQLException("No suitable driver", "08001");
                }
            }
        }
        catch (Throwable t) {
            String message = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLNestedException(message, t);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        if ((user = this.username) != null) {
            this.connectionProperties.put("user", user);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String pwd = this.password;
        if (pwd != null) {
            this.connectionProperties.put("password", pwd);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        return driverConnectionFactory;
    }

    protected void createConnectionPool() {
        GenericObjectPool gop = this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandoned() ? new AbandonedObjectPool(null, this.abandonedConfig) : new GenericObjectPool();
        gop.setMaxActive(this.maxActive);
        gop.setMaxIdle(this.maxIdle);
        gop.setMinIdle(this.minIdle);
        gop.setMaxWait(this.maxWait);
        gop.setTestOnBorrow(this.testOnBorrow);
        gop.setTestOnReturn(this.testOnReturn);
        gop.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        gop.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        gop.setTestWhileIdle(this.testWhileIdle);
        this.connectionPool = gop;
    }

    protected void createDataSourceInstance() throws SQLException {
        PoolingDataSource pds = new PoolingDataSource((ObjectPool)((Object)this.connectionPool));
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        pds.setLogWriter(this.logWriter);
        this.dataSource = pds;
    }

    protected void createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory, KeyedObjectPoolFactory statementPoolFactory, AbandonedConfig configuration) throws SQLException {
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory(driverConnectionFactory, (ObjectPool)((Object)this.connectionPool), statementPoolFactory, this.validationQuery, this.validationQueryTimeout, this.connectionInitSqls, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, configuration);
            BasicDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void validateConnectionFactory(PoolableConnectionFactory connectionFactory) throws Exception {
        Connection conn = null;
        try {
            conn = (Connection)connectionFactory.makeObject();
            connectionFactory.activateObject(conn);
            connectionFactory.validateConnection(conn);
            connectionFactory.passivateObject(conn);
        }
        finally {
            connectionFactory.destroyObject(conn);
        }
    }

    protected void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

