/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.util.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.util.graph.DefaultEdge;
import net.hydromatic.optiq.util.graph.DirectedGraph;
import org.eigenbase.util.ChunkList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadthFirstIterator<V, E extends DefaultEdge>
implements Iterator<V> {
    private final DirectedGraph<V, E> graph;
    private final List<V> list = new ChunkList<V>();
    private final Set<V> set = new HashSet<V>();

    public BreadthFirstIterator(DirectedGraph<V, E> graph, V root) {
        this.graph = graph;
        this.list.add(root);
    }

    @Override
    public boolean hasNext() {
        return !this.list.isEmpty();
    }

    @Override
    public V next() {
        V v = this.list.remove(0);
        for (DefaultEdge e : this.graph.getOutwardEdges(v)) {
            Object target = e.target;
            if (!this.set.add(target)) continue;
            this.list.add(target);
        }
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

