/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.RuleSet;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Programs {
    private static final Function<RuleSet, Program> RULE_SET_TO_PROGRAM = new Function<RuleSet, Program>(){

        @Override
        public Program apply(RuleSet ruleSet) {
            return Programs.of(ruleSet);
        }
    };

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Lists.transform(Arrays.asList(ruleSets), RULE_SET_TO_PROGRAM);
    }

    public static Program hep(ImmutableList<RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(final HepProgram hepProgram, final boolean noDag, final RelMetadataProvider metadataProvider) {
        return new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
                if (metadataProvider != null) {
                    ArrayList<RelMetadataProvider> list = Lists.newArrayList();
                    list.add(metadataProvider);
                    hepPlanner.registerMetadataProviders(list);
                    RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
                    rel.getCluster().setMetadataProvider(plannerChain);
                }
                hepPlanner.setRoot(rel);
                return hepPlanner.findBestExp();
            }
        };
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

