/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.materialize;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.clone.CloneSchema;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.MetaImpl;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqPrepare$ParseResult;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.MaterializationActor;
import net.hydromatic.optiq.materialize.MaterializationKey;
import net.hydromatic.optiq.materialize.MaterializationService$2;
import net.hydromatic.optiq.materialize.MaterializationService$3;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationService {
    private static final MaterializationService INSTANCE = new MaterializationService();
    private static final ThreadLocal<MaterializationService> THREAD_INSTANCE = new ThreadLocal<MaterializationService>(){

        @Override
        protected MaterializationService initialValue() {
            return new MaterializationService();
        }
    };
    private final MaterializationActor actor = new MaterializationActor();

    private MaterializationService() {
    }

    public MaterializationKey defineMaterialization(OptiqSchema schema, String viewSql, List viewSchemaPath, String tableName) {
        OptiqSchema.TableEntry tableEntry;
        Pair<String, Table> pair;
        OptiqConnection connection = MetaImpl.connect(schema.root(), null);
        MaterializationKey materializationKey = new MaterializationKey();
        RelDataType rowType = null;
        if (tableName != null) {
            Table materializedTable;
            pair = schema.getTable(tableName, true);
            Table table = materializedTable = pair == null ? null : (Table)pair.right;
            if (materializedTable == null) {
                OptiqPrepare.PrepareResult<Object> prepareResult = Schemas.prepare(connection, schema, viewSchemaPath, viewSql);
                rowType = prepareResult.rowType;
                JavaTypeFactory typeFactory = connection.getTypeFactory();
                materializedTable = CloneSchema.createCloneTable(typeFactory, RelDataTypeImpl.proto(prepareResult.rowType), Functions.adapt(prepareResult.structType.columns, new MaterializationService$2(this)), new MaterializationService$3(this, connection, prepareResult));
                schema.add(tableName, materializedTable);
            }
            tableEntry = schema.add(tableName, materializedTable);
        } else {
            tableEntry = null;
        }
        if (rowType == null) {
            pair = Schemas.parse(connection, schema, viewSchemaPath, viewSql);
            rowType = ((OptiqPrepare$ParseResult)((Object)pair)).rowType;
        }
        MaterializationActor.Materialization materialization = new MaterializationActor.Materialization(materializationKey, schema.root(), tableEntry, viewSql, rowType);
        this.actor.keyMap.put(materialization.key, materialization);
        return materializationKey;
    }

    public OptiqSchema.TableEntry checkValid(MaterializationKey materializationKey) {
        MaterializationActor.Materialization materialization = (MaterializationActor.Materialization)this.actor.keyMap.get(materializationKey);
        if (materialization != null) {
            return materialization.materializedTable;
        }
        return null;
    }

    public List<Prepare.Materialization> query(OptiqSchema rootSchema) {
        ArrayList<Prepare.Materialization> list = new ArrayList<Prepare.Materialization>();
        for (MaterializationActor.Materialization materialization : this.actor.keyMap.values()) {
            if (materialization.rootSchema != rootSchema || materialization.materializedTable == null) continue;
            list.add(new Prepare.Materialization(materialization.materializedTable, materialization.sql));
        }
        return list;
    }

    public static MaterializationService instance() {
        MaterializationService materializationService = THREAD_INSTANCE.get();
        if (materializationService != null) {
            return materializationService;
        }
        return INSTANCE;
    }
}

