/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.impl.jdbc.JdbcUtils$ObjectArrayRowBuilder$1;

public class JdbcUtils$ObjectArrayRowBuilder {
    private final ResultSet resultSet;
    private final int columnCount;
    private final Primitive[] primitives;
    private final int[] types;

    public JdbcUtils$ObjectArrayRowBuilder(ResultSet resultSet, Primitive[] primitiveArray, int[] nArray) throws SQLException {
        this.resultSet = resultSet;
        this.primitives = primitiveArray;
        this.types = nArray;
        this.columnCount = resultSet.getMetaData().getColumnCount();
    }

    public static Function1 factory(List list) {
        return new JdbcUtils$ObjectArrayRowBuilder$1(list);
    }

    public Object[] apply() {
        try {
            Object[] objectArray = new Object[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                objectArray[i] = this.value(i);
            }
            return objectArray;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private Object value(int n) throws SQLException {
        switch (this.types[n]) {
            case 93: {
                return JdbcUtils$ObjectArrayRowBuilder.shift(this.resultSet.getTimestamp(n + 1));
            }
            case 92: {
                return JdbcUtils$ObjectArrayRowBuilder.shift(this.resultSet.getTime(n + 1));
            }
            case 91: {
                return JdbcUtils$ObjectArrayRowBuilder.shift(this.resultSet.getDate(n + 1));
            }
        }
        return this.primitives[n].jdbcGet(this.resultSet, n + 1);
    }

    private static Timestamp shift(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        long l = timestamp.getTime();
        int n = TimeZone.getDefault().getOffset(l);
        return new Timestamp(l + (long)n);
    }

    private static Time shift(Time time) {
        if (time == null) {
            return null;
        }
        long l = time.getTime();
        int n = TimeZone.getDefault().getOffset(l);
        return new Time((l + (long)n) % 86400000L);
    }

    private static Date shift(Date date) {
        if (date == null) {
            return null;
        }
        long l = date.getTime();
        int n = TimeZone.getDefault().getOffset(l);
        return new Date(l + (long)n);
    }
}

