/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcToEnumerableConverter
extends ConverterRelImpl
implements EnumerableRel {
    protected JdbcToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, traits, input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToEnumerableConverter(this.getCluster(), traitSet, JdbcToEnumerableConverter.sole(inputs));
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression calendar_;
        BlockBuilder builder0 = new BlockBuilder(false);
        JdbcRel child = (JdbcRel)this.getChild();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        JdbcConvention jdbcConvention = (JdbcConvention)child.getConvention();
        String sql = this.generateSql(jdbcConvention.dialect);
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println("[" + sql + "]");
        }
        Hook.QUERY_PLAN.run(sql);
        Expression sql_ = builder0.append("sql", Expressions.constant(sql));
        int fieldCount = this.getRowType().getFieldCount();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression resultSet_ = Expressions.parameter(16, ResultSet.class, builder.newName("resultSet"));
        CalendarPolicy calendarPolicy = CalendarPolicy.of(jdbcConvention.dialect);
        switch (calendarPolicy) {
            case LOCAL: {
                calendar_ = builder0.append("calendar", Expressions.call(Calendar.class, "getInstance", new Expression[]{this.getTimeZoneExpression(implementor)}));
                break;
            }
            default: {
                calendar_ = null;
            }
        }
        if (fieldCount == 1) {
            ParameterExpression value_ = Expressions.parameter(Object.class, builder.newName("value"));
            builder.add(Expressions.declare(16, value_, null));
            this.generateGet(implementor, physType, builder, resultSet_, 0, value_, calendar_, calendarPolicy);
            builder.add(Expressions.return_(null, value_));
        } else {
            Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(fieldCount)));
            for (int i = 0; i < fieldCount; ++i) {
                this.generateGet(implementor, physType, builder, resultSet_, i, Expressions.arrayIndex(values_, Expressions.constant(i)), calendar_, calendarPolicy);
            }
            builder.add(Expressions.return_(null, values_));
        }
        ParameterExpression e_ = Expressions.parameter(SQLException.class, builder.newName("e"));
        Expression rowBuilderFactory_ = builder0.append("rowBuilderFactory", Expressions.lambda(Expressions.block(Expressions.return_(null, Expressions.lambda(Expressions.block(Expressions.tryCatch(builder.toBlock(), Expressions.catch_(e_, Expressions.throw_(Expressions.new_(RuntimeException.class, new Expression[]{e_}))))), new ParameterExpression[0]))), resultSet_));
        Expression enumerable = builder0.append("enumerable", Expressions.call(BuiltinMethod.RESULT_SET_ENUMERABLE_OF.method, Expressions.call(Schemas.unwrap(jdbcConvention.expression, JdbcSchema.class), BuiltinMethod.JDBC_SCHEMA_DATA_SOURCE.method, new Expression[0]), sql_, rowBuilderFactory_));
        builder0.add(Expressions.return_(null, enumerable));
        return implementor.result(physType, builder0.toBlock());
    }

    private UnaryExpression getTimeZoneExpression(EnumerableRelImplementor implementor) {
        return Expressions.convert_(Expressions.call((Expression)implementor.getRootExpression(), "get", Expressions.constant("timeZone")), TimeZone.class);
    }

    private void generateGet(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression resultSet_, int i, Expression target, Expression calendar_, CalendarPolicy calendarPolicy) {
        MethodCallExpression source;
        Primitive primitive = Primitive.ofBoxOr(physType.fieldClass(i));
        RelDataType fieldType = physType.getRowType().getFieldList().get(i).getType();
        ArrayList<Expression> dateTimeArgs = new ArrayList<Expression>();
        dateTimeArgs.add(Expressions.constant(i + 1));
        SqlTypeName sqlTypeName = fieldType.getSqlTypeName();
        boolean offset = false;
        switch (calendarPolicy) {
            case LOCAL: {
                dateTimeArgs.add(calendar_);
                break;
            }
            case NULL: {
                break;
            }
            case DIRECT: {
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            case SHIFT: {
                switch (sqlTypeName) {
                    case TIMESTAMP: 
                    case DATE: {
                        offset = true;
                    }
                }
            }
        }
        switch (sqlTypeName) {
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                source = Expressions.call(this.getMethod(sqlTypeName, fieldType.isNullable(), offset), Expressions.list().append(Expressions.call((Expression)resultSet_, this.getMethod2(sqlTypeName), dateTimeArgs)).appendIf(offset, (MethodCallExpression)((Object)this.getTimeZoneExpression(implementor))));
                break;
            }
            case ARRAY: {
                UnaryExpression x = Expressions.convert_(Expressions.call((Expression)resultSet_, this.jdbcGetMethod(primitive), Expressions.constant(i + 1)), Array.class);
                source = Expressions.call(BuiltinMethod.JDBC_ARRAY_TO_LIST.method, x);
                break;
            }
            default: {
                source = Expressions.call((Expression)resultSet_, this.jdbcGetMethod(primitive), Expressions.constant(i + 1));
            }
        }
        builder.add(Expressions.statement(Expressions.assign(target, source)));
    }

    private Method getMethod(SqlTypeName sqlTypeName, boolean nullable, boolean offset) {
        switch (sqlTypeName) {
            case DATE: {
                return (nullable ? BuiltinMethod.DATE_TO_INT_OPTIONAL : BuiltinMethod.DATE_TO_INT).method;
            }
            case TIME: {
                return (nullable ? BuiltinMethod.TIME_TO_INT_OPTIONAL : BuiltinMethod.TIME_TO_INT).method;
            }
            case TIMESTAMP: {
                return (nullable ? (offset ? BuiltinMethod.TIMESTAMP_TO_LONG_OPTIONAL_OFFSET : BuiltinMethod.TIMESTAMP_TO_LONG_OPTIONAL) : (offset ? BuiltinMethod.TIMESTAMP_TO_LONG_OFFSET : BuiltinMethod.TIMESTAMP_TO_LONG)).method;
            }
        }
        throw new AssertionError((Object)((Object)((Object)sqlTypeName) + ":" + nullable));
    }

    private Method getMethod2(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case DATE: {
                return BuiltinMethod.RESULT_SET_GET_DATE2.method;
            }
            case TIME: {
                return BuiltinMethod.RESULT_SET_GET_TIME2.method;
            }
            case TIMESTAMP: {
                return BuiltinMethod.RESULT_SET_GET_TIMESTAMP2.method;
            }
        }
        throw new AssertionError((Object)sqlTypeName);
    }

    private String jdbcGetMethod(Primitive primitive) {
        return primitive == null ? "getObject" : "get" + SqlFunctions.initcap(primitive.primitiveName);
    }

    private String generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        JdbcImplementor.Result result = jdbcImplementor.visitChild(0, this.getChild());
        return result.asQuery().toSqlString(dialect).getSql();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CalendarPolicy {
        NONE,
        NULL,
        LOCAL,
        DIRECT,
        SHIFT;


        static CalendarPolicy of(SqlDialect dialect) {
            switch (dialect.getDatabaseProduct()) {
                case MYSQL: {
                    return SHIFT;
                }
            }
            return NULL;
        }
    }
}

